@php
echo '<?xml version="1.0" encoding="UTF-8"?>
<?xml-stylesheet type="text/xsl" href="/sitemap.xsl"?>';
@endphp
<urlset xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd" xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">	

	@foreach($series as $s)
	<url>
		<loc>{{ $s->url }}</loc>
		<lastmod>{{ $s->created_at->tz('UTC')->toAtomString() }}</lastmod>
		<changefreq>always</changefreq>
		<priority>0.9</priority>
	</url>
	@endforeach		

	@foreach($series as $s)
	@foreach($s->seasons as $season)

		@if($s->season_torrents->count() == 0) @continue @endif

		@if(!in_array($season->season_number, $s->season_torrents->pluck('season_number')->toArray())) @continue  @endif

	<url>
		<loc>{{ $season->url }}</loc>
		<lastmod>{{ $season->created_at->tz('UTC')->toAtomString() }}</lastmod>
		<changefreq>always</changefreq>
		<priority>0.9</priority>
	</url>
	@endforeach
	@endforeach	

</urlset>