@extends('front.layouts.default')
@section('after_styles')

@stop
@section('content')
<div class="container">
	<div class="row" id="info-page">
		<div class="col-xs-20 col-md-10">
			<h2>User login</h2>
			<form id="login_form" method="post" action="{{action('AjaxController@login')}}" accept-charset="UTF-8" autocorrect="off" autocapitalize="off" spellcheck="off">
				{{csrf_field()}}
				<label for="username">Username or Email:</label> <input class="contact" name="username" type="text" id="username" value="">
				<label for="password">Password:</label> <input class="contact" name="password" type="password" value="" id="password">
				{!! Recaptcha::render(['theme'=>Config::Get('settings.recaptcha_colorscheme')]) !!}
				<span class="green-link">
					<a href="{{route('register')}}">Create an Account</a>
					<a href="{{url('forgot-password')}}">Forgot password?</a>
				</span>
				<div class="send-btn">
					<input class="button-green-download2-big" type="submit" value="Login">
				</div>
			</form>
		</div>
	</div>
</div>
@stop

@section('after_scripts')
<script type="text/javascript">

$("#login_form").on('submit', function(event) {
	event.preventDefault();
	
	$.ajax({
		url: $(this).attr('action'),
		type: $(this).attr('method'),
		data: $(this).serialize(),
	})
	.done(function(d) {
	    if(d == '')
			window.location.reload();
		else{
		    d = JSON.parse(d);
    		if(d.status == "error"){
    			toastr.error(d.message);
    			grecaptcha.reset();
    		}
		}
		console.log(d)
	})
	.fail(function() {
		toastr.error('Some error occured');
	});
	return false;
});
</script>
@stop