@extends('front.layouts.default')
@section('content')
<div class="container">
	<div class="row" id="info-page">
		<div class="col-xs-20 col-md-10">
			<h2>Reset your password</h2>
			<form id="fp_form" method="post" action="{{action('AjaxController@recover')}}" accept-charset="UTF-8" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="off">
				{{csrf_field()}}
				<label for="email">E-Mail:</label> <input class="contact" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="off" name="email" type="email" id="email">
				{!! Recaptcha::render(['theme'=>Config::Get('settings.recaptcha_colorscheme')]) !!}
				<div class="send-btn">
					<input class="button-green-download2-big" type="submit" value="Reset Password">
				</div>
			</form>
		</div>
		<div class="hidden-xs hidden-sm col-md-2"></div>
		<div class="hidden-xs hidden-sm col-md-8">
			<p class="text">If you have Forgotten your password, just type in your Email and we will send you instructions to reset your password.</p>
		</div>
	</div>
</div>
@stop
@section('after_scripts')
<script type="text/javascript">
$("#fp_form").on('submit', function(event) {
	event.preventDefault();
	
	$.ajax({
		url: $(this).attr('action'),
		type: $(this).attr('method'),
		data: $(this).serialize(),
	})
	.done(function(d) {
		d = JSON.parse(d);
		if(d.status == "error"){
			toastr.error(d.message);
		}
		else{
			toastr.success(d.message);
		}
		grecaptcha.reset();
	})
	.fail(function() {
		toastr.error('Some error occured');
	});
	return false;
});
</script>
@stop