@extends('front.layouts.default')
@section('content')
<div class="gray-bg">
	<div class="container">
		<div id="info-page">
			<div class="row">
				<div class="col-xs-20 col-md-12">
					<h1>{{$user->name}}</h1>
				</div>
				@if(Auth::check())
				@if(Auth::user()->hasRole('Administrator'))
				<div class="col-xs-20 col-md-4">
					<a class="edit-profile button-green-download2-big" href="{{url('admin/dashboard')}}">Admin Panel</a>
				</div>
				@endif				
				@if($user->id == Auth::user()->id)
				<div class="col-xs-20 col-md-4">
					<a class="edit-profile button-green-download2-big" href="{{route('user.edit')}}">Edit</a>
				</div>
				@endif
				@endif
			</div>			
			<div class="line"></div>
			<div class="row">
				<div class="col-xs-20">
					<h2>Statistics</h2>
				</div>
			</div>
			<div class="row">
				<div class="col-xs-20 col-md-13 profile-stats">
					<div class="profile-container">
						<p><span>Joined:</span> {{$user->created_at->format('Y-m-d H:i')}}</p>
						<p><span>Last Seen:</span> {{date('Y-m-d H:i',strtotime($user->last_seen))}}</p>
						<p><span>User Class:</span> {{$user->role()}}</p>
						<p><span>Downloads:</span> {{$download_count}}</p>
						<p><span>Uploads:</span> {{$upload_count}}</p>
					</div>
				</div>
				<div class="hidden-xs hidden-sm col-md-6">
					@if(empty($user->avatar))
					<img class="profile-img img-responsive pull-right" src="/img/default_avatar.jpg" alt="{{$user->name}} Profile">
					@else
					<img class="profile-img img-responsive pull-right" src="{{$user->avatar}}" alt="{{$user->name}} Profile">
					@endif
				</div>
			</div>
@if(!empty($user->about_text))
	@if(Auth::check())
		@if(Auth::user()->id == $user->id)
				<div class="row">
					<div class="col-xs-20">
						<div class="line"></div>
						<h2>About Me</h2>
						<p>{{$user->about_text}}</p>
					</div>
				</div>
		@else
				<div class="row">
					<div class="col-xs-20">
						<div class="line"></div>
						<h2>About {{$user->name}}</h2>
						<p>{{$user->about_text}}</p>
					</div>
				</div>
		@endif
	@else
				<div class="row">
					<div class="col-xs-20">
						<div class="line"></div>
						<h2>About {{$user->name}}</h2>
						<p>{{$user->about_text}}</p>
					</div>
				</div>
	@endif
@endif

			<div class="row">
				<div class="col-xs-20">
					<div class="line"></div>
					<h2>Recent Downloads</h2>
					<div class="row-fluid recent-downloads">
						@forelse($downloads as $movie)
						<div class="col-xs-10 col-sm-6 col-md-3">
							<a href="{{ $movie->url }}" title="{{$movie->title_long}}"><img src="{{$movie->thumbnail}}" alt="{{$movie->title_long}} download"></a>
						</div>
						@empty
						<h3 style="text-align: center;">No results</h3>
						@endforelse
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@stop