@extends('front.layouts.default')

@section('content')
<div class="container">
	<div class="row" id="info-page">
		<form id="register_form" method="post" action="{{action('AjaxController@register')}}" accept-charset="UTF-8" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="off">
			{{csrf_field()}}
			<div class="col-xs-20">
				<h2>Register an Account (Email Verification Is Optional) - Once You Register , You Can Login In Directly.</h2>
			</div>
			<div class="col-xs-20 col-md-10">
				<label for="username">Username:</label> <input class="contact" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="off" name="username" type="text" id="username" value="">
			</div>
			<div class="col-xs-20 col-md-10">
				<label for="email">E-Mail:</label> <input class="contact" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="off" name="email" type="email" id="email" value="">
			</div>
			<div class="col-xs-20 col-md-10">
				<label for="password">Password:</label> <input class="contact" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="off" name="password" type="password" value="" id="password">					
			</div>
			<div class="col-xs-20 col-md-10">
				<label for="password_confirmation">Confirm Password:</label> <input class="contact" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="off" name="password_confirmation" type="password" value="" id="password_confirmation">
				{!! Recaptcha::render(['theme'=>Config::Get('settings.recaptcha_colorscheme')]) !!}		
				<div class="send-btn">
					<input class="button-green-download2-big" type="submit" value="Register">
				</div>
			</div>
		</form>
	</div>
</div>
@stop
@section('after_scripts')
<script type="text/javascript">
$("#register_form").on('submit', function(event) {
	event.preventDefault();
	var formData = $(this).serialize();
	$.ajax({
		url: $(this).attr('action'),
		type: $(this).attr('method'),
		data: formData,
	})
	.done(function(d) {
		d = JSON.parse(d);
		if(d.status == "error"){
			toastr.error(d.message);			
		}
		else{
			toastr.success(d.message);
		}
		grecaptcha.reset();
	})
	.fail(function() {
		toastr.error('Some error occured');
	});
	return false;
});
</script>
@stop