@extends('front.layouts.default')

@section('content')
<div class="container" id="info-page">
	<form method="post" action="{{ route('user.edit') }}" accept-charset="UTF-8" autocomplete="off" enctype="multipart/form-data">
		{{csrf_field()}}
		<div class="row">
			<div class="col-xs-20 col-md-10">
				<h2>Change Password</h2>
				<label for="password">New Password:</label>
				<input class="contact" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="off" name="password" type="password" value="" id="password">
				<label for="password_confirmation">Confirm Password:</label>
				<input class="contact" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="off" name="password_confirmation" type="password" value="" id="password_confirmation">
				<h2>About You</h2>
				<label for="about_text">About Text:</label>
				<textarea class="contact" rows="7" name="about_text" cols="50" id="about_text">{{Input::old('about_text',$user->about_text)}}</textarea>
			</div>
			<div class="hidden-xs hidden-sm col-md-2"></div>
			<div class="col-xs-20 col-md-8">
				<div class="avatar-upload form-group">
					<h2>Avatar</h2>
					<label for="avatar_image">Upload Avatar</label>
					<input name="avatar_image" type="file" id="avatar_image">
					<p class="help-block">
						<br>
						<br>
						@if(!empty($user->avatar))
						<img class="profile-img img-responsive" src="{{$user->avatar}}" alt="{{$user->name}} Profile">
						@else
						<img class="profile-img img-responsive" src="/img/default_avatar.jpg" alt="{{$user->name}} Profile">
						@endif
					</p>
				</div>
			</div>
		</div>
		<div class="line"></div>
		<div class="row">
			<div class="col-xs-20">
				<p class="help-block"><b></b></p>
				<div class="send-btn">
					<input class="button-green-download2-big" type="submit" value="Save">
				</div>
			</div>
		</div>
	</form>
</div>
@stop