@extends('backpack::layout')

@section('header')
    <section class="content-header">
      <h1>
        {{ trans('backpack::base.dashboard') }}<small>{{Illuminate\Foundation\Inspiring::quote()}}</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="{{ url(config('backpack.base.route_prefix', 'admin')) }}">{{ config('backpack.base.project_name') }}</a></li>
        <li class="active">{{ trans('backpack::base.dashboard') }}</li>
      </ol>
    </section>
@endsection



@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-default">
                <div class="box-header with-border">
                    <div class="box-title">{{ trans('backpack::base.login_status') }}</div>
                </div>

                <div class="box-body">{{ trans('backpack::base.logged_in') }}</div>
            </div>
        </div>
    </div>

<div class="row">

        <!-- /.col -->
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box">
             <a href="{{url('admin/category')}}"> <span class="info-box-icon bg-red"><i class="fa fa-list"></i></span></a>

            <div class="info-box-content">
              <span class="info-box-text">Genres</span>
              <span class="info-box-number">{{number_format($genre_count)}}</span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>
        <!-- /.col -->

        <!-- fix for small devices only -->
        <div class="clearfix visible-sm-block"></div>

        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box">
            <span class="info-box-icon bg-green"><i class="fa fa-film"></i></span>

            <div class="info-box-content">
              <span class="info-box-text">Movies</span>
              <span class="info-box-number">{{number_format($movies_count)}}</span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>
        <!-- /.col -->
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box">
             <a href="{{url('admin/user')}}"> <span class="info-box-icon bg-yellow"><i class="ion ion-ios-people-outline"></i></span></a>

            <div class="info-box-content">
              <span class="info-box-text">Members</span>
              <span class="info-box-number">{{number_format($users_count)}}</span>
              <p><i class="fa fa-users text-green"></i> - {{$active_users_count}}, <b><i class="fa fa-users text-blue"></i> - </b>{{$inactive_users_count}}, <b><i class="fa fa-users text-red"></i> - </b>{{$banned_users_count}},</p>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>
        <!-- /.col -->

        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box">
           <a href="{{url('admin/page')}}"> <span class="info-box-icon bg-aqua"><i class="fa fa-file"></i></span>  </a>

            <div class="info-box-content">
              <span class="info-box-text">Pages</span>
              <span class="info-box-number">{{number_format($pages_count)}}</span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>        
</div>  





<div class="row">
  <div class="col-md-12">
              <!-- USERS LIST -->
              <div class="box box-danger">
                <div class="box-header with-border">
                  <h3 class="box-title">Recently Joined Members</h3>

                  <div class="box-tools pull-right">
                    <span class="label label-danger">{{$users->count()}} New Members</span>
                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body no-padding">
                  <ul class="users-list clearfix">
                    @forelse($users as $user)
                    <li style="width: 12.5%;">
                      <img src="{{$user->avatar}}" alt="User Image" class="img-fluid" width="80">
                      <a class="users-list-name" href="{{url('admin/user/'.$user->id.'/edit')}}">{{$user->name}}</a>
                      <span class="users-list-date">{{$user->created_at->diffForHumans()}}</span>
                    </li>
                    @empty
                      <h2>No Members</h2>
                    @endforelse

                  </ul>
                  <!-- /.users-list -->
                </div>
                <!-- /.box-body -->
                <div class="box-footer text-center">
                  <a href="{{url('admin/user')}}" class="uppercase">View All Users</a>
                </div>
                <!-- /.box-footer -->
              </div>
              <!--/.box -->
            </div>
</div>
@endsection
