<a href="#" class="btn btn-primary edit_selected" data-aurl="{{ url($crud->route.'/update-selected') }}" data-style="zoom-in"><span class="ladda-label"><i class="fa fa-edit"></i> {{ trans('backpack::crud.edit') }} selected {{ $crud->entity_name_plural }}</span></a>

@push('before_scripts')
<!-- Modal -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">Edit Selected {{ ucwords($crud->entity_name_plural) }}</h4>
      </div>
      <div class="modal-body">
            <div class="form-group">
                <label>Find</label>
                <input type="text" name="find" value="" class="form-control" autocomplete="off">
            </div>
            <div class="form-group">
                <label>Replace</label>
                <input type="text" name="replace" value="" class="form-control" autocomplete="off">
            </div>  
            
            <hr/>
            
            <div class="form-group">
                <label>Created at</label>
                <input type="text" name="created_at" class="form-control" placeholder="YYYY-MM-DD 00:00:00" autocomplete="off" value="{{ date('Y-m-d H:i:s') }}">
            </div>              
        
        <div class="row">
            
        <div class="col-sm-4">
            <div class="checkbox">
                <label>
                    <input type="radio" name="featured" value="0" checked>
                        Dont Use Featured
                </label>
            </div>
        </div>        
        
        <div class="col-sm-4">
            <div class="checkbox">
                <label>
                    <input type="radio" name="featured" value="1">
                        Featured
                </label>
            </div>
        </div>

        <div class="col-sm-4">
            <div class="checkbox">
                <label>
                    <input type="radio" name="featured" value="2">
                        Remove Featured
                </label>
            </div>
        </div>            
            
            
        </div>


        <div id="edit_response"></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary update_selected">Save</button>
      </div>
    </div>
  </div>
</div>

@endpush

@push('after_scripts')
<script>
$('.edit_selected').on('click',function(event){
    $('[name="find"]').val($('#text-filter-findme').val());
    $('#editModal').modal('toggle');
});

// Update Selected
$(".update_selected").on('click', function(event) {
	event.preventDefault();

	var url = $(this).data("action");

	var ids = [];
    $(':checkbox:checked').each(function(i){
          ids[i] = $(this).val();
    });


	$.ajax({
		url: "{{ url($crud->route.'/update-selected') }}",
		type: 'POST',
		data: {ids: ids, find: $('[name="find"]').val(), replace: $('[name="replace"]').val(), created_at: $('[name="created_at"]').val(), featured: $('[name="featured"]:checked').val()},
	})
	.done(function(d) {
		$('#edit_response').html(d);
	});
	
    return false;
});	
</script>
@endpush
