<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of the routes that are handled
| by your application. Just tell Laravel the URIs it should respond
| to using a Closure or controller method. Build something great!
|
*/
/*
Route::get('fix-slug',function(){
   
        $movies = \App\Models\Movie::all();
        
        foreach($movies as $m)
        {

              $item = \App\Models\Movie::find($m->id);
              if(!empty($item))
              {
                    $item->slug = str_slug($item->title_long);
                    try{
                        $item->save();
                    }
                    catch(\Exception $e)
                    {
                        continue;
                    }
              }
              
        }

        
});

*/

Route::get('api/v1/genre/{genre}',function($gen){

    $genre = \App\Models\Genre::where('name',$gen)->firstOrfail();
    $movies = \App\Models\Movie::where('genres','like','%'.$gen.'%')->get(['title_long','imdb_code']);
    
    return $movies;
});

Route::get('api/v1/featured',function(){

    $movies = \App\Models\Movie::where('featured',1)->get(['title_long','imdb_code']);
    
    return $movies;
});




Route::get('admin/feature-from-yts-zone',function(){

    $data = file_get_contents('https://yts.tf/api/v1/featured');
    $yts_zone_movies = json_decode($data);
    
    $imdb_codes = [];
    foreach($yts_zone_movies as $yts_zone_movie)
    {
        array_push($imdb_codes,$yts_zone_movie->imdb_code);
    }
    
    \App\Models\Movie::whereIn('imdb_code',$imdb_codes)->update(['featured'=>1]);
    
    $featured_count = \App\Models\Movie::where('featured',1)->count();
    
    echo "<strong>Featured Movies On Ytszone</strong> - ".count($imdb_codes)." <br>";
    echo "<strong>Featured Movies On this site</strong> - ".$featured_count." <br>";
 
    
});



Route::get('admin/genre-compare-yts-zone/{genre}',function($gen){

    $genre = \App\Models\Genre::where('name',$gen)->firstOrfail();
    $data = file_get_contents('https://yts.tf/api/v1/genre/'.$gen);
    $yts_zone_movies = json_decode($data);

    $movies_got_genre = [];
    $movies_got_torrents = [];
    echo "<strong>Missing Movies</strong> <br>";
    echo "=====================================<br>";
    echo "<table border='1'>";
    foreach($yts_zone_movies as $yts_zone_movie)
    {
        $movie = \App\Models\Movie::where('imdb_code',$yts_zone_movie->imdb_code)->first();
        

        if(empty($movie))
        { 
            echo "<tr>";
            echo "<td>".$yts_zone_movie->title_long . '</td>  <td><input value="' . $yts_zone_movie->imdb_code .'" readonly></td>';
            echo "</tr>";
            continue;
        }
        else{
            
            if(stripos($movie->genres,$gen) === false){ 
                
                $mgens = explode(',',$movie->genres);
                array_push($mgens,$genre->name);
                $movie->genres = implode(',',$mgens);
                $movie->save();
                array_push($movies_got_genre,['title_long'=>$movie->title_long, 'imdb_code'=>$movie->imdb_code]);
            }
        }
        $imdb_code = $movie->imdb_code;
           
           /*
        $check_torrents = \App\Models\Torrent::where('movie_id',$movie->id)->whereIn('hash',array_column($yts_zone_movie->torrents,'hash'))->get(['hash'])->pluck('hash')->toArray();
      
        $torrentPath = 'uploads/movies/'.str_slug($movie->title_long.' '.$imdb_code);
        if (!file_exists($torrentPath)) 
        {
            mkdir($torrentPath, 0775, true);
            chmod($torrentPath, 0775);       
        }
                 
        foreach($yts_zone_movie->torrents as $t)
        {
            if(in_array($t->hash,$check_torrents)) continue;
            
            $torrent_file = $torrentPath."/".str_slug($movie->title_long)."-".$t->quality.".torrent";

            try{
                file_put_contents($torrent_file, fopen('https://yts.tf'.$t->file, 'r'));
            }
            catch(\Exception $e)
            {
                continue;
            }
            $check = \App\Models\Torrent::where('hash',$t->hash)->first();
            if(!empty($check)) continue;
            
            $torrent = new \App\Models\Torrent();
            $torrent->movie_id = $movie->id;
            $torrent->hash = $t->hash;
            $torrent->quality = $t->quality;
            $torrent->type = $t->type;
            $torrent->seeds = $t->seeds;
            $torrent->peers = $t->peers;
            $torrent->size_bytes = $t->size_bytes;
            $torrent->file = "/".$torrent_file;
            $torrent->resolution = $t->resolution;
            $torrent->created_at = $t->created_at;
            $torrent->save();         
            
            array_push($movies_got_torrents,['title_long'=>$movie->title_long, 'imdb_code'=>$movie->imdb_code]);
        }
        */
    }
    
    echo "</table>";
    echo "<br><br><br>";
    echo "<strong>Movies Got Genre</strong> <br>";
    echo "=====================================<br>";    
    foreach($movies_got_genre as $movie_got_genre)
    {
        echo $movie_got_genre['title_long'] . ' - ' . $movie_got_genre['imdb_code'] .'<br>';        
    }
        /*
    echo "<br><br><br>";
    echo "<strong>Movies Got Torrents</strong> <br>";
    echo "=====================================<br>";    
    foreach($movies_got_torrents as $movies_got_torrent)
    {
        echo $movies_got_torrent['title_long'] . ' - ' . $movies_got_torrent['imdb_code'] .'<br>';        
    }
    */
    
});


/*

Route::get('move-movie-images',function(){

   $movies = \App\Models\Movie::where('background_image','like','/uploads%')->inRandomOrder()->limit(5000)->get();
   foreach($movies as $movie)
   {
        $imdb_code = $movie->imdb_code;

        $imageFolderPath = 'images/movies/'.str_slug($movie->title_long.' '.$movie->imdb_code);

        $status = '';
        if(starts_with($movie->cover_image,'/uploads') && file_exists(ltrim($movie->cover_image,'/')) ){

            if(!file_exists($imageFolderPath)){  
              mkdir($imageFolderPath, 0755, true);
            }             
            
            $cover_image_path = $imageFolderPath.'/'.basename($movie->cover_image);
            if(rename(ltrim($movie->cover_image,'/'),$cover_image_path)){
                $movie->cover_image = $cover_image_path;
                $status .= 'cover updated';
            }
        }    
        else{
            $movie->cover_image = null;
        }
        
        if(starts_with($movie->background_image,'/uploads') && file_exists(ltrim($movie->background_image,'/'))){

            if(!file_exists($imageFolderPath)){  
              mkdir($imageFolderPath, 0755, true);
            }             
            
            $background_image_path = $imageFolderPath.'/'.basename($movie->background_image);
            if(rename(ltrim($movie->background_image,'/'),$background_image_path)){
                $movie->background_image = $background_image_path;
                $status .= ", bg updated";   
            }
        }
        else{
            $movie->background_image = null;
        }

        
        $movie->save();
        \Cache::flush();
        
        echo $movie->title_long . " images ".$status."<br/>";
   }
    
});
*/
Route::get('get-tmdb-movie-images',function(){

   $movies = \App\Models\Movie::where('cover_image','like','/uploads%')->inRandomOrder()->limit(50)->get();
   foreach($movies as $movie)
   {
        $imdb_code = $movie->imdb_code;
        $status = 'not updated';
        try{
            $data = file_get_contents('https://api.themoviedb.org/3/movie/'.$imdb_code.'?api_key=443880ff623cdfa7c3599a4d56c167ff');
        }
        catch(\Exception $e)
        {
            continue;
        }  
        
        $data = json_decode($data);
         
        if(!empty($data->poster_path)) 
        {
            if(file_exists(ltrim($movie->cover_image,'/'))) unlink(ltrim($movie->cover_image,'/'));
            $cover_image_path = 'https://image.tmdb.org/t/p/w342'.$data->poster_path;
            $movie->cover_image = $cover_image_path;
        }
        
        if(!empty($data->backdrop_path))
        {
            if(file_exists(ltrim($movie->background_image,'/'))) unlink(ltrim($movie->background_image,'/'));
            $background_image_path = (!empty($data->backdrop_path)) ? 'https://image.tmdb.org/t/p/w1280'.$data->backdrop_path : '';
            $movie->background_image = $background_image_path;
            $status = "updated";            
        }
        
        $movie->save();
        \Cache::flush();
        
        echo $movie->title_long . " images ".$status."<br/>";
   }
    
});




/* Admin Routes */


Route::group(
[
    'namespace'  => 'Backpack\Base\app\Http\Controllers',
    'middleware' => 'eco.web',
    'prefix'     => config('backpack.base.route_prefix'),
],
function () {

    // if not otherwise configured, setup the auth routes
    if (config('backpack.base.setup_auth_routes')) {
   //     Route::auth();
        Route::get('login', function(){
            abort(404);
        });
        Route::post('login', 'Auth\LoginController@doLogin');        
        Route::get('logout', 'Auth\LoginController@logout');
    }

    // if not otherwise configured, setup the dashboard routes
    if (config('backpack.base.setup_dashboard_routes')) {
        Route::get('dashboard', 'AdminController@dashboard');
        Route::get('/', 'AdminController@redirect');
    }
});

Route::group(
[
    'namespace'  => 'Barryvdh\Elfinder',
    'middleware' => 'admin',
    'prefix'     => 'admin/elfinder',
],
function () {


    Route::get('/',  ['as' => 'elfinder.index', 'uses' =>'ElfinderController@showIndex']);
    Route::any('connector', ['as' => 'elfinder.connector', 'uses' => 'ElfinderController@showConnector']);
    Route::get('popup/{input_id}', ['as' => 'elfinder.popup', 'uses' => 'ElfinderController@showPopup']);
    Route::get('filepicker/{input_id}', ['as' => 'elfinder.filepicker', 'uses' => 'ElfinderController@showFilePicker']);
    Route::get('tinymce', ['as' => 'elfinder.tinymce', 'uses' => 'ElfinderController@showTinyMCE']);
    Route::get('tinymce4', ['as' => 'elfinder.tinymce4', 'uses' => 'ElfinderController@showTinyMCE4']);
    Route::get('ckeditor', ['as' => 'elfinder.ckeditor', 'uses' => 'ElfinderController@showCKeditor4']);
   
});


//Non auth routes

//Auth Routes
Route::group([
    'prefix'     => config('backpack.base.route_prefix', 'admin'),
    'middleware' => ['web'],
    'namespace'  => 'Admin',
], function () {
    
    Route::get('update-movie-slugs','MovieController@autoUpdateSlugs');


    Route::get('eztv-get-latest', 'SeriesCrudController@eztvGetLatest')->name('eztv_get_latest');
    Route::get('eztv-get-all', 'SeriesCrudController@eztvGetAll')->name('eztv_get_all');
    
    Route::get('tmdb-get-all', 'SeriesCrudController@tmdbGetTv')->name('tmdb_get_all');
    Route::get('tmdb-update-all', 'SeriesCrudController@tmdbUpdateAll')->name('tmdb_update_all');



    Route::get('yts-get-all', 'ScrapController@ytsGetAll')->name('yts_get_all');
    Route::get('yts-get-latest', 'ScrapController@ytsGetLatest')->name('yts_get_latest');
    Route::get('yts-get-by-query', 'ScrapController@ytsGetByQuery')->name('yts_get_by_query');
    Route::get('yts-get-date-uploaded', 'ScrapController@ytsGetDateUploaded')->name('yts_get_date_uploaded');	
    	
    	
    	
    // Subs
    Route::get('yify-get-all-subtitles', 'ScrapController@yifyGetAllSubtitles')->name('yify_get_all_subtitles');
    Route::get('yify-update-subtitles', 'ScrapController@yifyUpdateSubtitles')->name('yify_update_subtitles');
    Route::get('yify-get-year-subtitles', 'ScrapController@yifyGetByYearSubtitles')->name('yify_get_year_subtitles');

});


//Auth Routes
Route::group([
    'prefix'     => config('backpack.base.route_prefix', 'admin'),
    'middleware' => ['admin'],
    'namespace'  => 'Admin',
], function () {
    
    Route::get('movie/{id}/tmdb-images','MovieCrudController@tmdbImages')->name('admin.movie.tmdb_images');
    
    Route::get('movie/{id}/torrents-tgx','MovieCrudController@tgx')->name('admin.movie.tgx_torrents');
    Route::post('movie/{id}/torrents-tgx','MovieCrudController@tgxStore');    
    

    Route::post('movie/{id}/torrents-1337','MovieCrudController@t1337Store')->name('admin.movie.t1337_torrents');

    Route::get('series/{id}/get-torrents','SeriesCrudController@getTorrents')->name('admin.series.get_torrents');
    Route::post('series/{id}/get-torrents','SeriesCrudController@storeTorrents');

    Route::get('movies-mass-edit','MovieController@massEdit')->name('movies_mass_edit');
    Route::post('movies-mass-edit','MovieController@massUpdate');     

    Route::get('series-mass-edit','SeriesCrudController@massEdit')->name('series_mass_edit');
    Route::post('series-mass-edit','SeriesCrudController@massUpdate');    
    
    Route::get('scrapper/tmdb','TmdbController@create');
    Route::post('scrapper/tmdb','TmdbController@store');
    
    Route::post('movie/update-selected', 'MovieController@updateSelected');
    Route::get('movie/add', 'MovieController@create');
    Route::post('movie/add', 'MovieController@save');
    Route::get('movie/edit/{id}', 'MovieController@edit');
    Route::post('movie/edit/{id}', 'MovieController@update');
    Route::get('movie/{id}/torrent', 'TorrentController@index');
    Route::get('movie/{id}/torrent/create', 'TorrentController@create');
    Route::post('movie/{id}/torrent/create', 'TorrentController@save');    
    Route::get('movie/{id}/torrent/{torrent}/edit', 'TorrentController@edit');
    Route::post('movie/{id}/torrent/{torrent}/edit', 'TorrentController@update');
    Route::get('movie/{id}/torrent/{torrent}/delete', 'TorrentController@destroy');

    //videos
    Route::get('movie/{id}/video', 'VideoController@index');
    Route::get('movie/{id}/video/create', 'VideoController@create');
    Route::post('movie/{id}/video/create', 'VideoController@save');    
    Route::get('movie/{id}/video/{video}/edit', 'VideoController@edit');
    Route::post('movie/{id}/video/{video}/edit', 'VideoController@update');
    Route::get('movie/{id}/video/{video}/delete', 'VideoController@destroy');    

    //season videos
    Route::get('series/{series}/seasons/{season}/video','SVideoController@index');
    Route::get('series/{series}/seasons/{season}/video/create', 'SVideoController@create');
    Route::post('series/{series}/seasons/{season}/video/create', 'SVideoController@save');    
    Route::get('series/{series}/seasons/{season}/video/{video}/edit', 'SVideoController@edit');
    Route::post('series/{series}/seasons/{season}/video/{video}/edit', 'SVideoController@update');
    Route::get('series/{series}/seasons/{season}/video/{video}/delete', 'SVideoController@destroy'); 

    // CRUD resources and other admin routes
    CRUD::resource('monster', 'MonsterCrudController');

    //Genre
    CRUD::resource('genre', 'GenreCrudController');

    //Movie
    CRUD::resource('movie', 'MovieCrudController');     

    CRUD::resource('redirects', 'RedirectCrudController');      

    //Artist
    Route::get('artist/ajax-artist-names', 'ArtistCrudController@getArtists');
    CRUD::resource('artist', 'ArtistCrudController');

    //Scrapper
    Route::get('scrapper/yts', 'ScrapController@ytsShow');
    Route::post('scrapper/yts', 'ScrapController@yts'); 
    Route::post('scrapper/yify', 'ScrapController@yify')->name('yifysubs'); 

    //Series
    Route::post('series/update-selected', 'SeriesCrudController@updateSelected');
    Route::get('seasons/{season}/torrent','STorrentController@index')->name('admin.season.torrents');
    Route::get('seasons/{season}/torrent/create', 'STorrentController@create');
    Route::post('seasons/{season}/torrent/create', 'STorrentController@save');    
    Route::get('seasons/{season}/torrent/{torrent}/edit', 'STorrentController@edit');
    Route::post('seasons/{season}/torrent/{torrent}/edit', 'STorrentController@update');
    Route::get('seasons/{season}/torrent/{torrent}/delete', 'STorrentController@destroy');    


    Route::get('episodes/{episode}/torrent','ETorrentController@index')->name('admin.episode.torrents');
    Route::get('episodes/{episode}/torrent/create', 'ETorrentController@create');
    Route::post('episodes/{episode}/torrent/create', 'ETorrentController@save');    
    Route::get('episodes/{episode}/torrent/{torrent}/edit', 'ETorrentController@edit');
    Route::post('episodes/{episode}/torrent/{torrent}/edit', 'ETorrentController@update');
    Route::get('episodes/{episode}/torrent/{torrent}/delete', 'ETorrentController@destroy');


    
    Route::get('series/{id}/torrents-tgx','SeriesCrudController@tgx')->name('admin.series.tgx_torrents');
    
    Route::post('seasons/torrents-tgx','SeasonCrudController@tgxStore');    
    Route::post('episodes/torrents-tgx','EpisodeCrudController@tgxStore');    
    
    
    Route::get('series/{id}/torrents-1337','SeriesCrudController@t1337')->name('admin.series.t1337_torrents');
    Route::post('seasons/torrents-1337','SeasonCrudController@t1337Store');    
    Route::post('episodes/torrents-1337','EpisodeCrudController@t1337Store');

    CRUD::resource('episodes', 'EpisodeCrudController');
    CRUD::resource('seasons', 'SeasonCrudController'); 

    Route::get('series/tmdb','SeriesCrudController@tmdb');   
    Route::post('series/tmdb','SeriesCrudController@tmdbStore');     
    CRUD::resource('series', 'SeriesCrudController');   
    Route::post('series/update','SeriesCrudController@update');   

    
 //   Route::get('scrapper/imdb', 'ScrapController@imdbShow');
 //   Route::post('scrapper/imdb', 'ScrapController@imdb');    
/*    Route::get('scrapper/imdb-series', 'ScrapController@imdbSeriesShow');
    Route::post('scrapper/imdb-series', 'ScrapController@imdbSeries');*/

  //  Route::get('scrapper/yifyco', 'ScrapController@yifyCoShow');
 //   Route::post('scrapper/yifyco', 'ScrapController@yifyCo');      

  //  Route::get('scrapper/bmovies', 'ScrapController@bmoviesShow');
 //   Route::post('scrapper/bmovies', 'ScrapController@bmovies');  
 //   Route::get('scrapper/bmovies-mass/{start}/{end}', 'ScrapController@bmoviesMass');


});



/* Front Routes */

//Auth Routes
Route::group([
    'middleware' => ['eco.auth'],
], function () {
    // CRUD resources and other admin routes
    Route::get('logout', 'UserController@logout')->name('logout');
    Route::get('settings', 'UserController@edit')->name('user.edit');
    Route::post('settings', 'UserController@update');
});


Route::group([
    'middleware' => ['eco.web'],
], function () {



Route::get('verify','PageController@verifyShow')->name('verify');
Route::post('verify','PageController@verify')->name('verify');

//Non auth routes
Route::get('home', 'HomeController@home');
Route::get('/', 'HomeController@index')->name('home');

Route::get('{anything}/view/{title}/{year}',function($anything,$title,$year){

    $movie = \App\Models\Movie::where('slug',str_slug($title.' '.$year))->firstOrfail();
    return redirect($movie->url,301);
    
});


Route::get('trending', 'MovieController@trending')->name('movie.trending');
Route::get('latest', 'MovieController@latest')->name('movie.latest');
Route::get('upcoming', 'MovieController@upcoming')->name('movie.upcoming');

Route::get('movies', 'MovieController@index')->name('movie.index');
Route::get('movies/{slug}', 'MovieController@show')->name('movie.show');
Route::get('movies/{id}/subtitles', 'MovieController@subtitles')->name('movie.subtitles.get');
Route::get('download/{hash}', 'MovieController@download')->name('movie.torrent.download');

Route::get('blog', 'BlogController@index')->name('blog.index');
Route::get('blog/{slug}', 'BlogController@article')->name('blog.show');

//Route::get('movies/search', 'MovieController@search');
//Route::get('movies/{slug}', 'MovieController@detail');

Route::get('contact', 'PageController@contact')->name('contact');
Route::post('contact', 'PageController@contactPost');

Route::get('ajax/search', 'AjaxController@ajaxSearch')->name('ajax_search');

Route::get('login', 'UserController@login')->name('login');
Route::post('ajax/login', 'AjaxController@login');

Route::get('register', 'UserController@register')->name('register');
Route::post('ajax/register', 'AjaxController@register');

Route::get('forgot-password', 'UserController@recover')->name('forgot_password');
Route::post('forgot-password', 'AjaxController@recover');

Route::get('ajax/like/movie/{id}', 'AjaxController@vote')->name('ajax_like');
//Route::get('ajax/like/season/{id}', 'AjaxController@svote');

Route::get('user/{username}', 'UserController@profile')->name('user.show');

Route::get('resend/{id}/activate','UserController@resendActivationCode')->name('resend_activate');
Route::get('activate/{activation_code}','UserController@activate')->name('activate');

Route::get('ajax/series-search', 'AjaxController@ajaxSeriesSearch');

//Series
Route::get('series', 'SeriesController@index')->name('series.index');
Route::get('season-download/{hash}', 'SeasonController@download')->name('season.torrent.download');
Route::get('episode-download/{hash}', 'EpisodeController@download')->name('episode.torrent.download');
Route::get('series/{slug}', 'SeriesController@show')->name('series.show');
Route::get('seasons/{slug}', 'SeasonController@show')->name('season.show');
Route::get('episodes/{slug}', 'EpisodeController@show')->name('episode.show');


//Route::get('sitemap.xml', 'PageController@sitemap')->name('sitemap');


Route::get('sitemap.xml','SitemapController@index')->name('sitemap');
Route::get('sitemap-misc.xml','SitemapController@misc')->name('sitemap_misc');
Route::get('sitemap-movies-{year}-{month}.xml','SitemapController@movies')->name('sitemap_movie');
Route::get('sitemap-series-{year}-{month}.xml','SitemapController@series')->name('sitemap_series');


    Route::get('{page}/{slug}', 'PageController@index')->name('page.show');
    Route::get('{page}/{pagetwo}/{slug}', 'PageController@index')->name('page.show');
    Route::get('{page}/{pagetwo}/{pagethree}/{slug}', 'PageController@index')->name('page.show');
    Route::get('{page}/{pagetwo}/{pagethree}/{pagefour}/{slug}', 'PageController@index')->name('page.show');
    Route::get('{page}/{pagetwo}/{pagethree}/{pagefour}/{pagefive}/{slug}', 'PageController@index')->name('page.show');
    Route::get('{page}/{pagetwo}/{pagethree}/{pagefour}/{pagefive}/{pagesix}/{slug}', 'PageController@index')->name('page.show');
    Route::get('{slug}', 'PageController@index')->name('page.show');

});



//Route::get('api/article', 'Api\ArticleController@index');
//Route::get('api/article/{id}', 'Api\ArticleController@show');



