<?php $__env->startSection('header'); ?>
    <section class="content-header">
      <h1>
        <?php echo e(trans('backpack::base.dashboard')); ?><small><?php echo e(Illuminate\Foundation\Inspiring::quote()); ?></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="<?php echo e(url(config('backpack.base.route_prefix', 'admin'))); ?>"><?php echo e(config('backpack.base.project_name')); ?></a></li>
        <li class="active"><?php echo e(trans('backpack::base.dashboard')); ?></li>
      </ol>
    </section>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="box box-default">
                <div class="box-header with-border">
                    <div class="box-title"><?php echo e(trans('backpack::base.login_status')); ?></div>
                </div>

                <div class="box-body"><?php echo e(trans('backpack::base.logged_in')); ?></div>
            </div>
        </div>
    </div>

<div class="row">

        <!-- /.col -->
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box">
             <a href="<?php echo e(url('admin/category')); ?>"> <span class="info-box-icon bg-red"><i class="fa fa-list"></i></span></a>

            <div class="info-box-content">
              <span class="info-box-text">Genres</span>
              <span class="info-box-number"><?php echo e(number_format($genre_count)); ?></span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>
        <!-- /.col -->

        <!-- fix for small devices only -->
        <div class="clearfix visible-sm-block"></div>

        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box">
            <span class="info-box-icon bg-green"><i class="fa fa-film"></i></span>

            <div class="info-box-content">
              <span class="info-box-text">Movies</span>
              <span class="info-box-number"><?php echo e(number_format($movies_count)); ?></span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>
        <!-- /.col -->
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box">
             <a href="<?php echo e(url('admin/user')); ?>"> <span class="info-box-icon bg-yellow"><i class="ion ion-ios-people-outline"></i></span></a>

            <div class="info-box-content">
              <span class="info-box-text">Members</span>
              <span class="info-box-number"><?php echo e(number_format($users_count)); ?></span>
              <p><i class="fa fa-users text-green"></i> - <?php echo e($active_users_count); ?>, <b><i class="fa fa-users text-blue"></i> - </b><?php echo e($inactive_users_count); ?>, <b><i class="fa fa-users text-red"></i> - </b><?php echo e($banned_users_count); ?>,</p>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>
        <!-- /.col -->

        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box">
           <a href="<?php echo e(url('admin/page')); ?>"> <span class="info-box-icon bg-aqua"><i class="fa fa-file"></i></span>  </a>

            <div class="info-box-content">
              <span class="info-box-text">Pages</span>
              <span class="info-box-number"><?php echo e(number_format($pages_count)); ?></span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>        
</div>  





<div class="row">
  <div class="col-md-12">
              <!-- USERS LIST -->
              <div class="box box-danger">
                <div class="box-header with-border">
                  <h3 class="box-title">Recently Joined Members</h3>

                  <div class="box-tools pull-right">
                    <span class="label label-danger"><?php echo e($users->count()); ?> New Members</span>
                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body no-padding">
                  <ul class="users-list clearfix">
                    <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li style="width: 12.5%;">
                      <img src="<?php echo e($user->avatar); ?>" alt="User Image" class="img-fluid" width="80">
                      <a class="users-list-name" href="<?php echo e(url('admin/user/'.$user->id.'/edit')); ?>"><?php echo e($user->name); ?></a>
                      <span class="users-list-date"><?php echo e($user->created_at->diffForHumans()); ?></span>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                      <h2>No Members</h2>
                    <?php endif; ?>

                  </ul>
                  <!-- /.users-list -->
                </div>
                <!-- /.box-body -->
                <div class="box-footer text-center">
                  <a href="<?php echo e(url('admin/user')); ?>" class="uppercase">View All Users</a>
                </div>
                <!-- /.box-footer -->
              </div>
              <!--/.box -->
            </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backpack::layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>