

<?php $__env->startSection('meta'); ?>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<link rel="alternate" href="<?php echo e(url()->current()); ?>" hreflang="en" />
<meta name="revisit-after" content="1 days">
<meta name="robots" content="INDEX,FOLLOW">

<meta name="description" content="<?php echo e($movie->meta_description); ?>" />
<meta name="keywords" content="<?php echo e($movie->meta_keywords); ?>" />

<meta property="og:title" content="<?php echo e($movie->meta_title); ?>" />
<meta property="og:image" content="<?php echo e($movie->thumbnail); ?>" />
<meta property="og:description" content="<?php echo e($movie->meta_description); ?>" />
<meta property="og:url" content="<?php echo e(url()->current()); ?>" />

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:url" value="<?php echo e(url()->current()); ?>">
<meta name="twitter:title" content="<?php echo e($movie->meta_title); ?>">
<meta name="twitter:description" content="<?php echo e($movie->meta_description); ?>">
<meta name="twitter:image" content="<?php echo e($movie->thumbnail); ?>" />

<?php $__env->stopSection(); ?>

<?php $__env->startSection('after_styles'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.1.25/jquery.fancybox.min.css" />

<link rel="stylesheet" href="<?php echo e(url('css/pages/movie.min.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('after_scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.1.25/jquery.fancybox.min.js"></script>

<script type="text/javascript">
$("a.fancybox").fancybox({
   type: "iframe",
});	
</script>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('background_image'); ?>
	<?php if(!empty($movie->background_image)): ?>
<div id="background-image" style="background: url(<?php echo e($movie->background); ?>) no-repeat center center; background-size: cover; -webkit-background-size: cover;-moz-background-size: cover; -o-background-size: cover;"></div>
<div id="background-overlay"></div>
	<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container" id="movie-content" itemscope itemtype="http://schema.org/Movie">

	<div class="row">
		<div id="mobile-movie-info" class="visible-xs col-xs-20">
			<h1><?php echo e($movie->title); ?> YIFY</h1>
			<h2><?php echo e($movie->year); ?></h2>
			<h2><?php echo e(str_replace(',',' - ',$movie->genres)); ?></h2>
		</div>
		<div id="movie-poster" class="col-xs-10 col-sm-6 col-lg-5">


		   <a class="button-green-download2-big" href="https://get-link.xyz/go/?title=<?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>)" rel="nofollow sponsored" target="_blank" style="margin-bottom:8px;"><span class="icon-in"></span>Download in HD</a>
		    <a class="button-green-download2-big" href="https://get-link.xyz/get/?title=<?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>)" rel="nofollow sponsored" target="_blank" style="margin-bottom:8px;"><span class="icon-screen"></span> Stream in HD</a>
		    

			<?php if(Auth::check()): ?>
				<?php if(Auth::user()->hasRole('Administrator')): ?>
				<a class="button-green-download2-big" href="<?php echo e(route('admin.movie.tgx_torrents',[$movie->id])); ?>" style="margin-bottom:8px;">TGX</a>
				<a class="button-green-download2-big" href="<?php echo e(route('admin.movie.tgx_torrents',[$movie->id])); ?>" style="margin-bottom:8px;">1337x</a>
					<a class="button-green-download2-big" href="<?php echo e(url('admin/movie/edit/'.$movie->id)); ?>" style="margin-bottom:8px;">Edit Movie</a>
					<a class="button-green-download2-big" href="<?php echo e(url('admin/movie/'.$movie->id.'/torrent')); ?>" style="margin-bottom:8px;">Edit Torrents</a>
				<?php endif; ?>	
			<?php endif; ?>

		    
			<img class="img-responsive lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="<?php echo e($movie->thumbnail); ?>" alt="<?php echo e($movie->title); ?> YIFY Torrent" title="<?php echo e($movie->title); ?> On <?php echo e(strtoupper(request()->getHost())); ?>" />
			<a class="torrent-modal-download button-green-download2-big " href="javascript:void(0);"><span class="icon-in"></span>Download</a>
		</div>
		
		
		
		
		<div class="modal modal-download">
			<div class="modal-container" style="background-color:black;">
				<div class="modal-title"> Select movie quality </div>
				<span class="modal-close glyphicon glyphicon-remove"></span>
				<div class="modal-content">
				    <table class="table">
				        <thead>
                    <tr>
                        <td>Quality</td>
                        <td>Name</td>
                        <td>Size</td>
                        <td>Download</td>
                        <td>Magnet</td>
                    </tr>
                    </thead>
                    <tbody>
					<?php $__empty_1 = true; $__currentLoopData = $movie->torrents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $torrent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
					
                    <tr>
                        <td><?php echo e($torrent->quality); ?></td>
                        <td><?php echo e(strtoupper($torrent->type)); ?></td>
                        <td><?php echo e($torrent->size_f); ?></td>
                        <td><a download href="<?php echo e($torrent->download_url); ?>" rel="nofollow" title="<?php echo e($torrent->meta_title); ?>"><span class="icon-in" style="color:green"></span></a></td>
                        <td><a data-torrent-id="<?php echo e($torrent->id); ?>" href="magnet:?xt=urn:btih:<?php echo e($torrent->hash); ?>&dn=<?php echo e(urlencode($movie->title)); ?>&<?php echo e(config('settings.torrent_trackers')); ?>" class="magnet-download download-torrent magnet" title="<?php echo e($torrent->meta_magnet_title); ?>" rel="nofollow" style="margin-top: 0;"><span>Magnet</span></a></td>
                    </tr>					
					
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
					<tr>
					    <td colspan="5" class="text-center">Coming soon</td>
					</tr>
					<?php endif; ?>
					</tbody>
                    </table>


				</div>
			</div>
		</div>
		
		
		
		
		<div id="movie-info" class="col-xs-10 col-sm-14 col-md-7 col-lg-8 col-lg-offset-1 movie-info" data-movie-id="<?php echo e($movie->id); ?>">
			<div class="hidden-xs">
				<h1><?php echo e($movie->title); ?> YIFY</h1>
				<h2><?php echo e($movie->year); ?></h2>
				<h2><?php echo e(str_replace(',',' - ',$movie->genres)); ?></h2>
			</div>
			<p class="hidden-xs hidden-sm">
				<em class="pull-left">Available in: &nbsp;</em>
					<?php $__empty_1 = true; $__currentLoopData = $movie->torrents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $torrent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
					<a href="<?php echo e($torrent->download_url); ?>" rel="nofollow sponsored" title="<?php echo e($torrent->meta_title); ?>"><?php echo e($torrent->quality.'.'.strtoupper($torrent->type)); ?></a>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
					<a href="#" rel="nofollow" title="<?php echo e($movie->title); ?>">Coming Soon</a>
					<?php endif; ?>

			</p>			
			<p class="hidden-xs hidden-sm">
				<em class="pull-left">Watch Online: &nbsp;</em>
					<?php if(!empty($movie->video_link)): ?>
					<a href="<?php echo e(($movie->torrents->count() > 0) ? $movie->video_link : config('settings.watch_movie_alt')); ?>" <?php if($movie->torrents->count() > 0): ?> class="fancybox" <?php else: ?> target="_blank" <?php endif; ?> rel="nofollow" title="<?php echo e($movie->title); ?>"><span class="icon-screen" style="    margin-right: 5px;color: <?php echo e(config('settings.theme_pattern_color')); ?>;"></span> Watch Now </a>
					<?php endif; ?>
			</p>		
			<p class="hidden-xs hidden-sm">
			    
			<a href="<?php echo e('https://yify-subs.net/movie-imdb/'. $movie->imdb_code); ?>" target="_blank" title="Download subtitles for <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) 1080p"><span class="icon-in download_subtitles"></span> Download Subtitles</a>
		
			</p>
			<div class="bottom-info">
				<div class="rating-row">					
					<span title="Likes" class="icon icon-heart"></span>
					<span id="movie-likes"><?php echo e($movie->like_count); ?></span><span class="hidden-xs"> - Likes</span>
				</div>

				<div class="rating-row ">
					<a class="icon" rel="nofollow" target="_blank" href="https://www.rottentomatoes.com/m/<?php echo e(str_replace('-','_',str_slug($movie->title))); ?>" title="Rotten Tomatoes Critics - Rotten"> <img src="/img/rt-rotten.png" alt="Rotten Tomatoes Critics - Rotten - <?php echo e(strtoupper(request()->getHost())); ?>" /> </a>
					<span><?php echo e($movie->tomato_critics); ?>&#37;</span><span class="hidden-xs"> - Critics</span>
				</div>
				<div class="rating-row ">
					<a class="icon" rel="nofollow" target="_blank" href="https://www.rottentomatoes.com/m/<?php echo e(str_replace('-','_',str_slug($movie->title))); ?>" title="Rotten Tomatoes Audience - Spilled"> <img src="/img/rt-spilled.png" alt="Rotten Tomatoes Audience - Spilled - <?php echo e(strtoupper(request()->getHost())); ?>" /> </a>
					<span><?php echo e($movie->tomato_audience); ?>&#37;</span><span class="hidden-xs"> - Audience</span>
				</div>

<div class="rating-row" itemprop="aggregateRating" itemscope="" itemtype="http://schema.org/AggregateRating"> <a class="icon" href="https://www.imdb.com/title/<?php echo e($movie->imdb_code); ?>/" title="<?php echo e($movie->title); ?> IMDb Rating" target="_blank">
<img src="/img/logo-imdb.svg" alt="<?php echo e($movie->title); ?> Rating For <?php echo e($movie->title); ?> By <?php echo e(strtoupper(request()->getHost())); ?>"> </a>
<span itemprop="itemReviewed" style="display: none;"><?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>)</span>
<span itemprop="ratingValue"><?php echo e($movie->rating); ?></span>
<span itemprop="bestRating" style="display: none;">10</span> <span itemprop="ratingCount" style="display: none;"><?php echo e($movie->download_count); ?></span> 
<span class="hidden-xs icon-star"></span> 
</div>
				<?php if(!empty($movie->direct_link)): ?>
				<div class="rating-row hidden-sm hidden-xs">
				
				</div>
				<?php endif; ?>
				
					<div class="rating-row hidden-sm hidden-xs">
			
				</div>
				
				<div class="rating-row hidden-sm hidden-xs v211">
		            <?php if(config('settings.advertisement') == 1): ?>
		                <?php if(!empty(config('settings.advertisement_block_2'))): ?>                    
		                    <?php echo config('settings.advertisement_block_2'); ?>

		                <?php else: ?>
							<a href="<?php echo e(route('contact')); ?>" style="color: white; font-weight: bold">Advertise with Us</a>
		                <?php endif; ?>
		            <?php endif; ?>					
				</div>

			<p class="hidden-md hidden-lg">
				<?php $__empty_1 = true; $__currentLoopData = $movie->torrents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $torrent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
				<a href="<?php echo e($torrent->download_url); ?>" rel="nofollow sponsored" title="<?php echo e($torrent->meta_title); ?>"><span class="icon-in" style="color: <?php echo e(config('settings.theme_pattern_color')); ?>;"></span> <?php echo e($torrent->quality.'.'.strtoupper($torrent->type)); ?></a>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
				<a href="#" rel="nofollow" title="Coming soon <?php echo e($movie->title); ?>">Coming soon</a>
				<?php endif; ?>

			</p>


				<p class="hidden-md hidden-lg">
					<?php if(!empty($movie->video_link)): ?>
					<a href="<?php echo e($movie->video_link); ?>" class="fancybox" rel="nofollow" title="Watch <?php echo e($movie->title); ?> Online On <?php echo e(strtoupper(request()->getHost())); ?>"><span class="icon-screen" style="    margin-right: 5px;color: <?php echo e(config('settings.theme_pattern_color')); ?>;"></span> Watch Online </a>
					<?php endif; ?>

				</p>

			<p class="hidden-md hidden-lg">
			
			
				<a href="<?php echo e('https://yify-subs.net/movie-imdb/'. $movie->imdb_code); ?>" target="_blank" title="Download subtitles for <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) 1080p"><span class="icon-in download_subtitles"></span> Download Subtitles</a>
			
			</p>


			</div>
		</div>
	
	
		<div class="col-md-5 hidden-xs hidden-sm">
		     <a class="btn btn-danger btn-block mb-2 ml-4" href="/latest" target="_blank" style="width:100%;">LATEST MOVIES</a>
		     <a class="btn btn-danger btn-block mb-2 ml-4" href="/trending" target="_blank" style="width:100%;">TRENDING MOVIES</a>
		     <a class="btn btn-danger btn-block mb-2 ml-4" href="/upcoming" target="_blank" style="width:100%;">UPCOMING MOVIES</a>
		</div>
	<span></span>
	
	<div id="movie-related" class="col-md-6 hidden-xs hidden-sm">
			<p>Trending :</p>
			
			
			
					<a href="/movies/john-wick-chapter-4-2023" target="_blank" title="John Wick: Chapter 4 yts"><img class="img-fluid lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/vZloFAK7NmvMGKE7VkF5UHaz0I.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/vZloFAK7NmvMGKE7VkF5UHaz0I.jpg" alt="John Wick: Chapter 4 yts"></a>


<a href="/movies/renfield-2023" target="_blank" title="Renfield yts"><img class="img-fluid lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/p6yUjhvNGQpFZilKwOKbxQ1eHlo.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/p6yUjhvNGQpFZilKwOKbxQ1eHlo.jpg" alt="Renfield yts"></a>

<a href="/movies/dungeons-dragons-honor-among-thieves-2023" target="_blank" title="Dungeons & Dragons: Honor Among Thieves yts"><img class="img-fluid lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/A7AoNT06aRAc4SV89Dwxj3EYAgC.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/A7AoNT06aRAc4SV89Dwxj3EYAgC.jpg" alt="Dungeons & Dragons: Honor Among Thieves yts"></a>


<a href="/movies/evil-dead-rise-2023" target="_blank" title="Evil Dead Rise yts"><img class="img-fluid lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/5ik4ATKmNtmJU6AYD0bLm56BCVM.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/5ik4ATKmNtmJU6AYD0bLm56BCVM.jpg" alt="Evil Dead Rise yts"></a>


<a href="/movies/air-2023" target="_blank" title="Air yts"><img class="img-fluid lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/76AKQPdH3M8cvsFR9K8JsOzVlY5.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/76AKQPdH3M8cvsFR9K8JsOzVlY5.jpg" alt="Air yts"></a>

<a href="/movies/the-super-mario-bros-movie-2023" target="_blank" title="The Super Mario Bros. Movie yts"><img class="img-fluid lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/qNBAXBIQlnOThrVvA6mA2B5ggV6.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/qNBAXBIQlnOThrVvA6mA2B5ggV6.jpg" alt="The Super Mario Bros. Movie yts"></a>
	


		</div>
		
		
	</div>



	<div id="movie-sub-info" class="row">
		<div id="synopsis" class="col-sm-10 col-md-13 col-lg-12">
			<h3>Synopsis Of <?php echo e($movie->title); ?> Torrent On YIFY (<?php echo e(strtoupper(request()->getHost())); ?>) :</h3>
			<p class="hidden-sm hidden-md hidden-lg"> <?php echo e($movie->description_full); ?> </p>
			<p class="hidden-xs"> <?php echo e($movie->description_full); ?> </p>
			<p class="hidden-xs"> <?php echo e($movie->title); ?> YIFY MOVIE YTS: <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) Torrent, Download movie <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) over a torrent, <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) yify torrent, <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) magnet torrent, <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) quality HD, 1080, 720, 3D, Bluray </p>
			
			<?php if(!empty($movie->writer)): ?>
			<p>
			    <br /> <em><?php echo e($movie->title); ?> Writers : <b> <?php echo e($movie->writer); ?> </b></em>
			</p>
			<?php endif; ?>
			
			<p>
			    <?php if(!empty($movie->production)): ?><br /> <em><?php echo e($movie->title); ?> Production : <b> <?php echo e($movie->production); ?> </b></em><?php endif; ?>
			    <?php if(!empty($movie->box_office)): ?><br /> <em><?php echo e($movie->title); ?> Box Office : <b> <?php echo e($movie->box_office); ?> </b></em><?php endif; ?>
			    <?php if(!empty($movie->awards)): ?><br /> <em><?php echo e($movie->title); ?> Awards : <b> <?php echo e($movie->awards); ?> </b></em><?php endif; ?>
			    <?php if(!empty($movie->country)): ?><br /> <em><?php echo e($movie->title); ?> Country : <b> <?php echo e($movie->country); ?> </b></em><?php endif; ?>
			</p>
			
			<p>
				<?php if(!empty($movie->user)): ?><br /> <em>Added By : <a href="<?php echo e($movie->user->url); ?>"><?php echo e($movie->user->name); ?></a> </em><?php endif; ?>
				<br /> <em>Download Count : <b> <?php echo e(number_format($movie->download_count)); ?> </b></em>
				<br /> <em>Source : <b>YIFY Torrent / YTS</b></em>
				<br /> <em>Updated & Posted On : <?php echo e($movie->created_at->format('F d, Y \a\t h:i A')); ?></em>
			</p>
		</div>
		<div id="crew" class="col-sm-10 col-md-7 col-lg-offset-1">
			<?php if(!empty($movie->director)): ?>
			<div class="directors">
				<h3>Director</h3>
				<div class="list-cast">
					<div class="tableCell">
					
						
					</div>
					<div class="list-cast-info tableCell">
						<a class="name-cast" href="<?php echo e(route('movie.index',['keyword'=>$movie->director])); ?>"><span itemprop="director" itemscope itemtype="http://schema.org/Person"><span itemprop="name"><?php echo e($movie->director); ?></span></span></a>
					</div>
				</div>
			</div>
			<?php endif; ?>
			
			
			<?php if(!empty($movie->cast)): ?>
			<div class="actors">
				<h3>Cast</h3>
				<?php  $casts = explode(',',$movie->cast);  ?>
				<?php $__empty_1 = true; $__currentLoopData = $casts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cast): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
					<?php  
					//	$artist = \Helpers::artist($cast);
						$cast_photo = url('/img/default_avatar.jpg');
					//	if(!empty($artist)){
					//		if(!empty($artist->photo) && file_exists(ltrim($artist->photo,'/'))) $cast_photo = $artist->photo;
					//	}
					 ?>
				<div class="list-cast">
					<div class="tableCell">
						<a class="avatar-thumb" href="http://www.imdb.com/find?q=<?php echo e($cast); ?>" target="_blank" title="IMDb Profile"> <img class="lazyload" src="<?php echo e(url('img/default_avatar.jpg')); ?>" data-src="<?php echo e($cast_photo); ?>" alt="<?php echo e($cast); ?> Picture"> </a>
					</div>
					<div class="list-cast-info tableCell">
						<a class="name-cast" href="<?php echo e(url('movies?keyword='.$cast)); ?>"><span itemprop="actor" itemscope itemtype="http://schema.org/Person"><span itemprop="name"><?php echo e($cast); ?></span></span></a>
					</div>
				</div>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
					<div>No results</div>
				<?php endif; ?>
			</div>
			<?php endif; ?>
		</div>
	</div>
	
	
<div class="row trending_movies" style="margin-top:2rem;">
						
				<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/beau-is-afraid-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/wgVkkjigF31r1nZV80uV0xNIoun.jpg" alt="Beau Is Afraid YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.5 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/beau-is-afraid-2023" target="_blank" class="browse-movie-title">Beau Is Afraid YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>









<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/the-popes-exorcist-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/4IjRR2OW2itjQWQnmlUzvwLz9DQ.jpg" alt="The Pope's Exorcist YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/the-popes-exorcist-2023" target="_blank" class="browse-movie-title">The Pope's Exorcist YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>
				



<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/the-covenant-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/kVG8zFFYrpyYLoHChuEeOGAd6Ru.jpg" alt="The Covenant (Guy Ritchie's The Covenant) YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.5 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/the-covenant-2023" target="_blank" class="browse-movie-title">The Covenant (Guy Ritchie's The Covenant) Flute YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>




<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/guardians-of-the-galaxy-vol-3-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/y0G2ybLpVwIxYaPLT1qkn8J5o44.jpg" alt="Guardians of the Galaxy Vol. 3 YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.7 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/guardians-of-the-galaxy-vol-3-2023" target="_blank" class="browse-movie-title">Guardians of the Galaxy Vol. 3 YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>






<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/fast-x-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/jwMMQR69Xz9AYtX4u2uYJgfAAev.jpg" alt="Fast X YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">9.5 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/fast-x-2023" target="_blank" class="browse-movie-title">Fast X YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>






<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/the-little-mermaid-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/ym1dxyOk4jFcSl4Q2zmRrA5BEEN.jpg" alt="The Little Mermaid YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.3 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/the-little-mermaid-2023" target="_blank" class="browse-movie-title">The Little Mermaid YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>





<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/asteroid-city-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/c6ef028LNABssgrTA4xoOMu2KOO.jpg" alt="Asteroid City YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.1 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/asteroid-city-2023" target="_blank" class="browse-movie-title">Asteroid City YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>



<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/spider-man-across-the-spider-verse-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/zPoqAu4gxZRmcPzSLFJ9b0VciaL.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/zPoqAu4gxZRmcPzSLFJ9b0VciaL.jpg" alt="Spider-Man: Across the Spider-Verse YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/spider-man-across-the-spider-verse-2023" target="_blank" class="browse-movie-title">Spider-Man: Across the Spider-Verse Eye YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>


<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/transformers-rise-of-the-beasts-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/g1HcrEiN0UiSpjQMJ3Klzw8KOZS.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/g1HcrEiN0UiSpjQMJ3Klzw8KOZS.jpg" alt="Transformers: Rise of the Beasts YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/transformers-rise-of-the-beasts-2023" target="_blank" class="browse-movie-title">Transformers: Rise of the Beasts YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>



<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/elemental-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/qM5W4Q78hxuPwpD4FtbsbLilSF9.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/qM5W4Q78hxuPwpD4FtbsbLilSF9.jpg" alt="Elemental YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/elemental-2023" target="_blank" class="browse-movie-title">Elemental YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>



<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/the-flash-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/wtxQcQxqIVStja6DFksiwC1tER8.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/wtxQcQxqIVStja6DFksiwC1tER8.jpg" alt="The Flash YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/the-flash-2023" target="_blank" class="browse-movie-title">The Flash YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>





<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/haunted-mansion-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/kpLx1gDYolWLBNOmuFVvrqFKQK3.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/kpLx1gDYolWLBNOmuFVvrqFKQK3.jpg" alt="Haunted Mansion YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/haunted-mansion-2023" target="_blank" class="browse-movie-title">Haunted Mansion YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>



<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/meg-2-the-trench-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/umYbu5PWSi0rQjUXUQCBwNmJyAS.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/umYbu5PWSi0rQjUXUQCBwNmJyAS.jpg" alt="Meg 2: The Trench YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/meg-2-the-trench-2023" target="_blank" class="browse-movie-title">Meg 2: The Trench YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>





<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/insidious-fear-the-dark-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/uS1AIL7I1Ycgs8PTfqUeN6jYNsQ.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/uS1AIL7I1Ycgs8PTfqUeN6jYNsQ.jpg" alt="Insidious: The Red Door YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/insidious-fear-the-dark-2023" target="_blank" class="browse-movie-title">Insidious: The Red Door YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>





<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/gran-turismo-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/1g8r5f7qUQ6ETHbQ0TxPI5ZaT30.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/1g8r5f7qUQ6ETHbQ0TxPI5ZaT30.jpg" alt="Gran Turismo YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/gran-turismo-2023" target="_blank" class="browse-movie-title">Gran Turismo YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>





<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/indiana-jones-and-the-dial-of-destiny-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/sv7iVXYVJTtOUAM9KGwsIuO0dEc.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/sv7iVXYVJTtOUAM9KGwsIuO0dEc.jpg" alt="Indiana Jones and the Dial of Destiny YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/indiana-jones-and-the-dial-of-destiny-2023" target="_blank" class="browse-movie-title">Indiana Jones and the Dial of Destiny YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>





<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/teenage-mutant-ninja-turtles-mutant-mayhem-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/89p1KhlrLxYBKoOsLBB0Zygfgrd.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/89p1KhlrLxYBKoOsLBB0Zygfgrd.jpg" alt="Teenage Mutant Ninja Turtles: Mutant Mayhem YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/teenage-mutant-ninja-turtles-mutant-mayhem-2023" target="_blank" class="browse-movie-title">Teenage Mutant Ninja Turtles: Mutant Mayhem YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>


<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/mission-impossible-dead-reckoning-part-one-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/pZCa8WgnP0AgVHsFjvuUDhcNjOJ.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/pZCa8WgnP0AgVHsFjvuUDhcNjOJ.jpg" alt="Mission: Impossible — Dead Reckoning Part One YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/mission-impossible-dead-reckoning-part-one-2023" target="_blank" class="browse-movie-title">Mission: Impossible — Dead Reckoning Part One YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>


  <div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/oppenheimer-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/bAFmcrCpXsJis5q0aaXvCz3dTiX.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/bAFmcrCpXsJis5q0aaXvCz3dTiX.jpg" alt="Oppenheimer YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/oppenheimer-2023" target="_blank" class="browse-movie-title">Oppenheimer YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>
  
  
    <div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/barbie-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/cgYg04miVQUAG2FKk3amSnnHzOp.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/cgYg04miVQUAG2FKk3amSnnHzOp.jpg" alt="Barbie YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/barbie-2023" target="_blank" class="browse-movie-title">Barbie YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>
  
  
  
      <div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/the-marvels-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/rp3cjGabBAVpZtKyY4jiwikzj3H.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/rp3cjGabBAVpZtKyY4jiwikzj3H.jpg" alt="The Marvels YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/the-marvels-2023" target="_blank" class="browse-movie-title">The Marvels YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>
  
  
  
      <div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/the-hunger-games-the-ballad-of-songbirds-snakes-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/p6Jx50T0jM5LaGdPZxeuKEwRkjY.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/p6Jx50T0jM5LaGdPZxeuKEwRkjY.jpg" alt="The Hunger Games: The Ballad of Songbirds and Snakes YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/the-hunger-games-the-ballad-of-songbirds-snakes-2023" target="_blank" class="browse-movie-title">The Hunger Games: The Ballad of Songbirds and Snakes YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>
  
  
  
  
      <div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/blue-beetle-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/xQoej3bB0ShPJZEkEhlYst5MViI.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/xQoej3bB0ShPJZEkEhlYst5MViI.jpg" alt="Blue Beetle YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/blue-beetle-2023" target="_blank" class="browse-movie-title">Blue Beetle YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>
  
  
  
    <div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/wonka-2023" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/c5tzazjnSFpFamcS8Whyi5yWx69.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/c5tzazjnSFpFamcS8Whyi5yWx69.jpg" alt="Wonka YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/wonka-2023" target="_blank" class="browse-movie-title">Wonka YIFY</a>
						<div class="browse-movie-year">2023</div>						
					</div>
				</div>
  
														
			</div>	
	
	
	
	
	
	<div id="movie-tech-specs" class="row">
		<h3 class="hidden-xs hidden-sm col-md-5">Tech specs</h3>
		<?php $__currentLoopData = $movie->torrents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $torrent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		<span class="tech-quality col-md-2 <?php echo e($loop->iteration == 1 ? 'selected' : ''); ?>"> <?php echo e($torrent->quality.'.'.strtoupper(str_limit($torrent->type,3,''))); ?> </span>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		<?php $__currentLoopData = $movie->torrents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $torrent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		<div class="tech-spec-info col-xs-20 <?php echo e($loop->iteration > 1 ? 'hidden-tech-info' : ''); ?>">
			<div class="row">
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"><span title="File Size" class="icon-folder"></span> <?php echo e($torrent->size_f); ?> <div></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Resolution" class="icon-expand"></span> <?php echo e($torrent->resolution); ?> <div></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Language" class="icon-volume-medium"></span> <?php echo e($movie->language); ?> <div></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="MPA Rating" class="icon-eye"></span> <?php echo e((!empty($movie->mpa_rating)) ? $movie->mpa_rating : 'N/A'); ?> <div></div> </div>
			</div>
			<div class="row">
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Subtitles" class="glyphicon glyphicon-subtitles"></span> <a href="#subtitles">Subtitles</a> <div class="hidden-md hidden-lg"></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Frame Rate" class="icon-film"></span> <?php echo e($torrent->fps); ?> fps <div class="hidden-md hidden-lg"></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Runtime" class="icon-clock"></span> <?php echo e($movie->runtime_f); ?> <div class="visible-xs"></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Peers and Seeds" class="tech-peers-seeds">P/S</span> <?php echo e(number_format($torrent->peers)); ?> / <?php echo e(number_format($torrent->seeds)); ?> </div>
			</div>
		</div>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

	</div>



	<?php if(config('settings.disqus') == 1): ?>
	<div class="row blog" style="margin-top: 20px;">
		<div class="col-xs-20">
		<?php echo config('settings.disqus_code'); ?>

		</div>
	</div>		
	<?php endif; ?>

<?php if(config('settings.facebook_comments') == 1): ?>	
	<div class="row blog" style="margin-top: 20px;">
		<div class="col-xs-20">
			<div class="fb-comments" data-href="<?php echo e($movie->slug); ?>" data-width="100%" data-numposts="10" data-colorscheme="dark"></div>
		</div>
	</div>
<?php endif; ?>	

</div>	
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>