
<?php $__env->startSection('after_styles'); ?>
<!-- include select2 css-->
<link href="<?php echo e(asset('vendor/adminlte/plugins/select2/select2.min.css')); ?>" rel="stylesheet" type="text/css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2-bootstrap-theme/0.1.0-beta.10/select2-bootstrap.min.css" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('after_scripts'); ?>
<script src="<?php echo e(asset('vendor/adminlte/plugins/select2/select2.min.js')); ?>"></script>
<script>
jQuery(document).ready(function($) {
    
    $('.select2_field').each(function (i, obj) {
        if (!$(obj).hasClass("select2-hidden-accessible"))
        {
            $(obj).select2({
                theme: "bootstrap"
            });
        }
    });
 });
</script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?> 
<!-- Content Header (Page header) -->
<section class="content-header">
  <h1> Add <span>Movie</span> </h1>
  <ol class="breadcrumb">
    <li><a href="<?php echo e(url('admin/dashboard')); ?>">Admin</a></li>
    <li><a href="<?php echo e(url('admin/movie')); ?>" class="text-capitalize">movies</a></li>
    <li class="active">Add</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
  <div class="row">
    <div class="col-md-8 col-md-offset-2"> 
      <!-- Default box --> 
      <a href="<?php echo e(url('admin/movie')); ?>"><i class="fa fa-angle-double-left"></i> Back to all <span>movies</span></a><br>
      <br>
      <form method="POST" action="" accept-charset="UTF-8" enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">Add a new movie</h3>
          </div>
          <div class="box-body row"> 

            <div class="form-group col-md-6">
              <label>Title</label>
              <input type="text" name="title" placeholder="Movie Name" class="form-control" value="<?php echo e(old('title')); ?>">
            </div>            

            <div class="form-group col-md-6">
              <label>Title Long</label>
              <input type="text" name="title_long" placeholder="Movie Name (Year)" class="form-control" value="<?php echo e(old('title_long')); ?>">
            </div>
            
            <div class="form-group col-md-6">
              <label>IMDB Code</label>
              <input type="text" name="imdb_code" placeholder="XXXXXXXXXXX" class="form-control" value="<?php echo e(old('imdb_code')); ?>">
            </div>            
            <div class="form-group col-md-6">
              <label>IMDB Rate</label>
              <input type="number" name="rating" placeholder="5" max="10" step="any" class="form-control" value="<?php echo e(old('rating',5)); ?>">
            </div>            

            <div class="form-group col-md-6">
              <label>Year</label>
              <input type="text" name="year" placeholder="YYYY" class="form-control" value="<?php echo e(old('year')); ?>">
            </div>            
            <div class="form-group col-md-6">
              <label>Runtime</label>
              <input type="number" name="runtime" placeholder="60" class="form-control" value="<?php echo e(old('runtime',60)); ?>">
            </div>

            <div class="form-group col-md-12">
                <label>Genre</label>
                <select name="genres[]" class="form-group select2_field" multiple="multiple" data-placeholder="Select Genres" style="width: 100%;">
                    <?php  if(!empty(old('genres'))) $selected_genres = old('genres'); else $selected_genres = [];  ?>
                    <?php $__currentLoopData = $movie_genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php 
                                                    if(in_array($genre->name,$selected_genres))
                                                        $selected = 'selected';
                                                    else
                                                        $selected = '';
                                                 ?>

                    <option value="<?php echo e($genre->name); ?>" <?php echo e($selected); ?>><?php echo e($genre->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="form-group col-md-6">
              <label>YouTube Trailer Code / Trailer Link</label>
              <input type="text" name="yt_trailer_code" placeholder="XXXXXXXXXXX" class="form-control" value="<?php echo e(old('yt_trailer_code')); ?>">
            </div>                
            <div class="form-group col-md-6">
              <label>Language</label>
              <input type="text" name="language" placeholder="English" class="form-control" value="<?php echo e(old('language','en')); ?>">
            </div>   

            <div class="form-group col-md-6">
              <label>MPA Rating</label>
              <input type="text" name="mpa_rating" placeholder="G / PG / PG-13 / R / NC-17" class="form-control" value="<?php echo e(old('mpa_rating')); ?>">
            </div>            
            <div class="form-group col-md-6">
              <label>Director</label>
              <input type="text" name="director" placeholder="Director Name" class="form-control" value="<?php echo e(old('director')); ?>">
            </div> 

            <div class="form-group col-md-12">
                <label>Cast</label>
                <textarea class="form-control" name="cast" placeholder="names separated by comma"><?php echo e(old('cast')); ?></textarea>
            </div>     


            <div class="form-group col-md-6">
              <label>Tomato Critics</label>
                <div class="input-group">              
              <input type="number" name="tomato_critics" placeholder="30" max="100" class="form-control" value="<?php echo e(old('tomato_critics',0)); ?>">
                                <div class="input-group-addon">
                    <i class="fa fa-percent"></i>
                  </div>
          </div>
            </div>            
            <div class="form-group col-md-6">
              <label>Tomato Audience</label>
                              <div class="input-group"> 
              <input type="number" name="tomato_audience" placeholder="30" max="100" class="form-control" value="<?php echo e(old('tomato_audience',0)); ?>">
                                              <div class="input-group-addon">
                    <i class="fa fa-percent"></i>
                  </div>
          </div>
            </div>  

            <div class="form-group col-md-12">
                <label>Cover Image</label>
                <input type="file" name="cover_image" class="form-control" accept="image/jpeg;image/png">
            </div>                

            <div class="form-group col-md-12">
                <label>Background Image</label>
                <input type="file" name="background_image" class="form-control" accept="image/jpeg;image/png">
            </div>              

            <div class="form-group col-md-12">
                <label>Screenshots</label>
                <input type="file" name="screenshots[]" class="form-control" accept="image/jpeg;image/png" multiple>
            </div>     

            <div class="form-group col-md-12">
                <label>Description</label>
                <textarea class="form-control" name="description_full"><?php echo e(old('description_full')); ?></textarea>
            </div>

            <div class="form-group col-md-6">
                <label>Active</label>
                <?php  $selected = old('active',1);  ?>
                <select name="active" class="form-control">
                    <option value="1" <?php if($selected == 1): ?> selected <?php endif; ?>>Yes</option>
                    <option value="0" <?php if($selected == 0): ?> selected <?php endif; ?>>No</option>
                </select>
            </div>

            <div class="form-group col-md-6">
                <label>Direct Download Link</label>
                <input type="text" class="form-control" name="direct_link" value="<?php echo e(old('direct_link')); ?>">
            </div>

            <div class="form-group col-md-6">
                <label>Find Me</label>
                <input type="text" class="form-control" name="findme" value="<?php echo e(old('findme')); ?>">
            </div>


          </div>
          <!-- /.box-body -->
          <div class="box-footer">
            <div id="saveActions" class="form-group">
                <button type="submit" class="btn btn-success" onclick=""> Save </button>
                <a href="<?php echo e(url('admin/movie')); ?>" class="btn btn-default"><span class="fa fa-ban"></span> &nbsp;Cancel</a> 
            </div>
          </div>
          <!-- /.box-footer--> 
        </div>
        <!-- /.box -->
      </form>
    </div>
  </div>
</section>
<!-- /.content --> 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after_scripts'); ?>
<script type="text/javascript">
window.onbeforeunload = renderLoading;
function renderLoading()
{
    Pace.stop()
    Pace.bar.render();
}  
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backpack::layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>