
<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>
  <span class="text-capitalize">torrents</span>
  <small>All  <span>torrents</span> in <?php echo e($episode->title_long); ?>.</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="<?php echo e(url('admin/dashboard')); ?>">Admin</a></li>
    <li><a href="<?php echo e(url('admin/series')); ?>" class="text-capitalize">series</a></li>
    <li><a href="<?php echo e(url('admin/seasons?series_id='.$series->id)); ?>" class="text-capitalize"><?php echo e($series->title_long); ?> seasons</a></li>
    <li><a href="#" class="text-capitalize"><?php echo e($season->name); ?></a></li>
    <li><a href="<?php echo e(url('admin/episodes?series_id='.$series->id.'&season_id='.$season->id)); ?>" class="text-capitalize">Episodes</a></li>
    <li class="active">Torrents</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
  <!-- Default box -->
  <div class="row">
    <!-- THE ACTUAL CONTENT -->
    <div class="col-md-12">
      <div class="box">
        <div class="box-header with-border">
          <a href="<?php echo e(url('admin/episodes?series_id='.$series->id.'&season_id='.$season->id)); ?>" class="btn btn-primary ladda-button" data-style="zoom-in"><span class="ladda-label"><i class="fa fa-angle-double-left"></i> Back</span></a>

          <a href="<?php echo e(url('admin/episodes/'.$episode->id.'/torrent/create')); ?>" class="btn btn-primary ladda-button" data-style="zoom-in"><span class="ladda-label"><i class="fa fa-plus"></i> Add Torrent</span></a>
          
          <div id="datatable_button_stack" class="pull-right text-right"></div>
        </div>
        <div class="box-body table-responsive">
          
          
          <table id="crudTable" class="table table-bordered table-striped display">
            <thead>
              <tr>                            
                <th>Name</th>
                <th>Quality</th>
                <th>Resolution</th>
                <th>Size</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php $__empty_1 = true; $__currentLoopData = $torrents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $torrent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>                            
                <td><?php echo e($torrent->name); ?></td>
                <td><?php echo e($torrent->quality); ?></td>
                <td><?php echo e($torrent->resolution); ?></td>

                <td><?php echo e(round($torrent->size_bytes/1024/1024,2)); ?> MB</td>
                <td>  <a href="<?php echo e(url('admin/episodes/'.$episode->id.'/torrent/'.$torrent->id.'/edit')); ?>" class="btn btn-xs btn-default"><i class="fa fa-edit"></i> Edit</a> <a href="<?php echo e(url('admin/episodes/'.$episode->id.'/torrent/'.$torrent->id.'/delete')); ?>" class="btn btn-xs btn-default"><i class="fa fa-trash"></i> Delete</a> </td>
              </tr>    
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                  <td colspan="7" align="center">No torrents available.</td>
                </tr> 
              <?php endif; ?>
            </tbody>            
            <tfoot>
              <tr>                            
                <th>Name</th>
                <th>Quality</th>
                <th>Resolution</th>
                <th>Size</th>
                <th>Actions</th>
              </tr>
            </tfoot>
          </table>
          </div><!-- /.box-body -->
          
          </div><!-- /.box -->
        </div>
      </div>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backpack::layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>