
<?php $__env->startSection('after_styles'); ?>
<!-- include select2 css-->
<link href="<?php echo e(asset('vendor/adminlte/plugins/select2/select2.min.css')); ?>" rel="stylesheet" type="text/css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2-bootstrap-theme/0.1.0-beta.10/select2-bootstrap.min.css" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('after_scripts'); ?>
<script src="<?php echo e(asset('vendor/adminlte/plugins/select2/select2.min.js')); ?>"></script>
<script>
jQuery(document).ready(function($) {
    
    $('.select2_field').each(function (i, obj) {
        if (!$(obj).hasClass("select2-hidden-accessible"))
        {
            $(obj).select2({
                theme: "bootstrap"
            });
        }
    });
 });
</script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?> 
<!-- Content Header (Page header) -->
<section class="content-header">
  <h1> Edit <span>Torrent</span> </h1>
  <ol class="breadcrumb">
    <li><a href="<?php echo e(url('admin/dashboard')); ?>">Admin</a></li>
    <li><a href="<?php echo e(url('admin/movie')); ?>" class="text-capitalize">movies</a></li>
    <li><a href="#" class="text-capitalize"><?php echo e($movie->title_long); ?></a></li>
    <li><a href="<?php echo e(url('admin/movie/'.$movie->id.'/torrent')); ?>" class="text-capitalize">Torrents</a></li>
    <li class="active">Edit</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
  <div class="row">
    <div class="col-md-8 col-md-offset-2"> 
      <!-- Default box --> 
      <a href="<?php echo e(url('admin/movie/'.$movie->id.'/torrent')); ?>"><i class="fa fa-angle-double-left"></i> Back to all <span>torrents</span> of <?php echo e($movie->title_long); ?></a><br>
      <br>
      <form method="POST" action="" accept-charset="UTF-8" enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">Edit a torrent from <?php echo e($movie->title_long); ?></h3>
          </div>
          <div class="box-body row"> 
      

            <div class="form-group col-md-6">
                <label>Quality</label>
                 <input type="text" name="quality" placeholder="720p" class="form-control" value="<?php echo e(old('quality',$torrent->quality)); ?>">
            </div>  
            <div class="form-group col-md-6">
                <label>Type</label>
                 <input type="text" name="type" placeholder="Web" class="form-control" value="<?php echo e(old('type',$torrent->type)); ?>">
            </div>                

            <div class="form-group col-md-6">
              <label>Resolution</label>
              <input type="text" name="resolution" placeholder="1920*1080 / 1280*720" class="form-control" value="<?php echo e(old('resolution',$torrent->resolution)); ?>">
            </div>

            <div class="form-group col-md-6">
              <label>Torrent Hash</label>
              <input type="text" name="hash" class="form-control" placeholder="XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" value="<?php echo e(old('hash',$torrent->hash)); ?>">
            </div>
            
            <div class="form-group col-md-6">
              <label>Peers</label>
              <input type="number" name="peers" placeholder="50" min="0" class="form-control" value="<?php echo e(old('peers',$torrent->peers
              )); ?>">
            </div>            
            <div class="form-group col-md-6">
              <label>Seeds</label>
              <input type="number" name="seeds" placeholder="50" min="0" class="form-control" value="<?php echo e(old('seeds',$torrent->seeds)); ?>">
            </div>            

            <div class="form-group col-md-6">
              <label>FPS(Framerate Per Second)</label>
              <input type="text" name="fps" placeholder="23.976" class="form-control" value="<?php echo e(old('fps',$torrent->fps)); ?>">
            </div>            
            <div class="form-group col-md-6">
              <label>File Size in MB</label>
              <input type="text" name="size_bytes" placeholder="1024" min="1" class="form-control" value="<?php echo e(round(old('size_bytes',$torrent->size_bytes/1024/1024),2)); ?>">
            </div>

            <div class="form-group col-md-12"> 
              <label>Torrent File</label><br/>
              <a href="<?php echo e($torrent->file); ?>">Download</a>
            </div>

            <div class="form-group col-md-12">
                <label>Change Torrent File</label>
                <input type="file" name="torrent_file" class="form-control">
            </div>                
    

          </div>
          <!-- /.box-body -->
          <div class="box-footer">
            <div id="saveActions" class="form-group">
                <button type="submit" class="btn btn-success" onclick=""> Save </button>
                <a href="<?php echo e(url('admin/movie/'.$movie->id.'/torrent')); ?>" class="btn btn-default"><span class="fa fa-ban"></span> &nbsp;Cancel</a> 
            </div>
          </div>
          <!-- /.box-footer--> 
        </div>
        <!-- /.box -->
      </form>
    </div>
  </div>
</section>
<!-- /.content --> 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after_scripts'); ?>
<script type="text/javascript">
window.onbeforeunload = renderLoading;
function renderLoading()
{
    Pace.stop()
    Pace.bar.render();
}  
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backpack::layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>