

<?php $__env->startSection('meta'); ?>
	<?php echo $__env->make('front.inc.default_meta', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after_styles'); ?>
<style type="text/css">	
@media (min-width: 768px)
{
	.poster {
	    height: 255px;
	}
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div id="main-search" class="content-dark hidden-sm hidden-xs">
	<div class="container">
		<form method="get" action="<?php echo e(route('movie.index')); ?>" accept-charset="UTF-8">
			<div id="main-search-fields" style="width: 880px;">
				<p class="pull-left term">Search Term:</p>
				<input name="keyword" placeholder="Search for a movie&hellip;" autocomplete="off" type="search" value="<?php echo e(app('request')->input('keyword')); ?>">
				<div class="selects-container">
					<p>Quality:</p>
					<select name="quality">
					<?php 
						$selected = app('request')->input('quality'); 
					 ?>						
						<option value="" <?php if($selected == ''): ?> selected <?php endif; ?>>All</option>
						<option value="720p" <?php if($selected == '720p'): ?> selected <?php endif; ?>>720p</option>
						<option value="1080p" <?php if($selected == '1080p'): ?> selected <?php endif; ?>>1080p</option>
						<option value="2160p" <?php if($selected == '2160p'): ?> selected <?php endif; ?>>2160p</option>
						<option value="3D" <?php if($selected == '3D'): ?> selected <?php endif; ?>>3D</option>
					</select>
				</div>
				<div class="selects-container">
					<p>Genre:</p>
					<select name="genre">
						<option value="">All</option>
						<?php 
							$selected = app('request')->input('genre'); 
						 ?>							
						<?php $__currentLoopData = $movie_genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($genre->name); ?>" <?php if($selected == $genre->name): ?> selected <?php endif; ?>><?php echo e($genre->name); ?></option>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</select>
				</div>
				<div class="selects-container">
					<p>Rating:</p>
					<select name="rating">
						<option value="0">All</option>
						<?php 
							$selected = app('request')->input('rating'); 
						 ?>
						<?php for($i = 9; $i > 0 ; $i--): ?>
						<option value="<?php echo e($i); ?>" <?php if($selected == $i): ?> selected <?php endif; ?>><?php echo e($i); ?>+</option>
						<?php endfor; ?>

					</select>
				</div>				
				<div class="selects-container">
					<p>Year:</p>
					<select name="year">
						<?php  $selected = request()->input('year')  ?>
						<option value="0">All</option>
						<?php for($i = date('Y'); $i >= 2019; $i--): ?>
						<option value="<?php echo e($i); ?>" <?php echo e($selected == $i ? 'selected' : ''); ?>><?php echo e($i); ?></option>
						<?php endfor; ?>
						<option value="2015-2018" <?php echo e($selected == '2015-2018' ? 'selected' : ''); ?>>2015-2018</option>
						<option value="2010-2014" <?php echo e($selected == '2010-2014' ? 'selected' : ''); ?>>2010-2014</option>
						<option value="2000-2009" <?php echo e($selected == '2000-2009' ? 'selected' : ''); ?>>2000-2009</option>
						<option value="1990-1999" <?php echo e($selected == '1990-1999' ? 'selected' : ''); ?>>1990-1999</option>
						<option value="1980-1989" <?php echo e($selected == '1980-1989' ? 'selected' : ''); ?>>1980-1989</option>
						<option value="1970-1979" <?php echo e($selected == '1970-1979' ? 'selected' : ''); ?>>1970-1979</option>
						<option value="1900-1969" <?php echo e($selected == '1900-1969' ? 'selected' : ''); ?>>1900-1969</option>
					</select>
				</div>
				<div class="selects-container">
				<p>Language:</p>
				<select name="language">
					<?php  $selected = request()->input('language')  ?>
				<option value="">All</option>
				<option value="en" <?php echo e($selected == 'en' ? 'selected' : ''); ?>>English</option>
				<option value="ja" <?php echo e($selected == 'ja' ? 'selected' : ''); ?>>Japanese</option>
				<option value="fr" <?php echo e($selected == 'fr' ? 'selected' : ''); ?>>French</option>
				<option value="it" <?php echo e($selected == 'it' ? 'selected' : ''); ?>>Italian</option>
				<option value="de" <?php echo e($selected == 'de' ? 'selected' : ''); ?>>German</option>
				<option value="es" <?php echo e($selected == 'es' ? 'selected' : ''); ?>>Spanish</option>
				<option value="zh" <?php echo e($selected == 'zh' ? 'selected' : ''); ?>>Chinese</option>
				<option value="hi" <?php echo e($selected == 'hi' ? 'selected' : ''); ?>>Hindi</option>
				<option value="cn" <?php echo e($selected == 'cn' ? 'selected' : ''); ?>>Cantonese</option>
				<option value="ko" <?php echo e($selected == 'ko' ? 'selected' : ''); ?>>Korean</option>
				<option value="ru" <?php echo e($selected == 'ru' ? 'selected' : ''); ?>>Russian</option>
				<option value="sv" <?php echo e($selected == 'sv' ? 'selected' : ''); ?>>Swedish</option>
				<option value="pt" <?php echo e($selected == 'pt' ? 'selected' : ''); ?>>Portuguese</option>
				<option value="pl" <?php echo e($selected == 'pl' ? 'selected' : ''); ?>>Polish</option>
				<option value="da" <?php echo e($selected == 'da' ? 'selected' : ''); ?>>Danish</option>
				<option value="no" <?php echo e($selected == 'no' ? 'selected' : ''); ?>>Norwegian</option>
				<option value="te" <?php echo e($selected == 'te' ? 'selected' : ''); ?>>Telugu</option>
				<option value="th" <?php echo e($selected == 'th' ? 'selected' : ''); ?>>Thai</option>
				<option value="nl" <?php echo e($selected == 'nl' ? 'selected' : ''); ?>>Dutch</option>
				<option value="fi" <?php echo e($selected == 'fi' ? 'selected' : ''); ?>>Finnish</option>
				<option value="cs" <?php echo e($selected == 'cs' ? 'selected' : ''); ?>>Czech</option>
				<option value="ta" <?php echo e($selected == 'ta' ? 'selected' : ''); ?>>Tamil</option>
				<option value="vi" <?php echo e($selected == 'vi' ? 'selected' : ''); ?>>Vietnamese</option>
				<option value="tr" <?php echo e($selected == 'tr' ? 'selected' : ''); ?>>Turkish</option>
				<option value="id" <?php echo e($selected == 'id' ? 'selected' : ''); ?>>Indonesian</option>
				<option value="fa" <?php echo e($selected == 'fa' ? 'selected' : ''); ?>>Persian</option>
				<option value="el" <?php echo e($selected == 'el' ? 'selected' : ''); ?>>Greek</option>
				<option value="ar" <?php echo e($selected == 'ar' ? 'selected' : ''); ?>>Arabic</option>
				<option value="he" <?php echo e($selected == 'he' ? 'selected' : ''); ?>>Hebrew</option>
				<option value="ur" <?php echo e($selected == 'ur' ? 'selected' : ''); ?>>Urdu</option>
				<option value="tl" <?php echo e($selected == 'tl' ? 'selected' : ''); ?>>Tagalog</option>
				<option value="hu" <?php echo e($selected == 'hu' ? 'selected' : ''); ?>>Hungarian</option>
				<option value="ms" <?php echo e($selected == 'ms' ? 'selected' : ''); ?>>Malay</option>
				<option value="bn" <?php echo e($selected == 'bn' ? 'selected' : ''); ?>>Bangla</option>
				<option value="is" <?php echo e($selected == 'is' ? 'selected' : ''); ?>>Icelandic</option>
				<option value="ro" <?php echo e($selected == 'ro' ? 'selected' : ''); ?>>Romanian</option>
				<option value="ca" <?php echo e($selected == 'ca' ? 'selected' : ''); ?>>Catalan</option>
				<option value="ml" <?php echo e($selected == 'ml' ? 'selected' : ''); ?>>Malayalam</option>
				<option value="et" <?php echo e($selected == 'et' ? 'selected' : ''); ?>>Estonian</option>
				<option value="uk" <?php echo e($selected == 'uk' ? 'selected' : ''); ?>>Ukrainian</option>
				<option value="pa" <?php echo e($selected == 'pa' ? 'selected' : ''); ?>>Punjabi</option>
				<option value="xx" <?php echo e($selected == 'xx' ? 'selected' : ''); ?>>xx</option>
				<option value="sr" <?php echo e($selected == 'sr' ? 'selected' : ''); ?>>Serbian</option>
				<option value="af" <?php echo e($selected == 'af' ? 'selected' : ''); ?>>Afrikaans</option>
				<option value="kn" <?php echo e($selected == 'kn' ? 'selected' : ''); ?>>Kannada</option>
				<option value="eu" <?php echo e($selected == 'eu' ? 'selected' : ''); ?>>Basque</option>
				<option value="sk" <?php echo e($selected == 'sk' ? 'selected' : ''); ?>>Slovak</option>
				<option value="bo" <?php echo e($selected == 'bo' ? 'selected' : ''); ?>>Tibetan</option>
				<option value="am" <?php echo e($selected == 'am' ? 'selected' : ''); ?>>Amharic</option>
				<option value="gl" <?php echo e($selected == 'gl' ? 'selected' : ''); ?>>Galician</option>
				<option value="bs" <?php echo e($selected == 'bs' ? 'selected' : ''); ?>>Bosnian</option>
				<option value="la" <?php echo e($selected == 'la' ? 'selected' : ''); ?>>Latin</option>
				<option value="mn" <?php echo e($selected == 'mn' ? 'selected' : ''); ?>>Mongolian</option>
				<option value="mr" <?php echo e($selected == 'mr' ? 'selected' : ''); ?>>Marathi</option>
				<option value="nb" <?php echo e($selected == 'nb' ? 'selected' : ''); ?>>Norwegian Bokmål</option>
				<option value="lv" <?php echo e($selected == 'lv' ? 'selected' : ''); ?>>Latvian</option>
				<option value="ps" <?php echo e($selected == 'ps' ? 'selected' : ''); ?>>Pashto</option>
				<option value="st" <?php echo e($selected == 'st' ? 'selected' : ''); ?>>Southern Sotho</option>
				<option value="iu" <?php echo e($selected == 'iu' ? 'selected' : ''); ?>>Inuktitut</option>
				<option value="so" <?php echo e($selected == 'so' ? 'selected' : ''); ?>>Somali</option>
				<option value="wo" <?php echo e($selected == 'wo' ? 'selected' : ''); ?>>Wolof</option>
				<option value="az" <?php echo e($selected == 'az' ? 'selected' : ''); ?>>Azerbaijani</option>
				<option value="sw" <?php echo e($selected == 'sw' ? 'selected' : ''); ?>>Swahili</option>
				<option value="ab" <?php echo e($selected == 'ab' ? 'selected' : ''); ?>>Abkhazian</option>
				<option value="ht" <?php echo e($selected == 'ht' ? 'selected' : ''); ?>>Haitian Creole</option>
				<option value="sh" <?php echo e($selected == 'sh' ? 'selected' : ''); ?>>Serbo-Croatian</option>
				<option value="ky" <?php echo e($selected == 'ky' ? 'selected' : ''); ?>>Kyrgyz</option>
				<option value="ak" <?php echo e($selected == 'ak' ? 'selected' : ''); ?>>Akan</option>
				<option value="os" <?php echo e($selected == 'os' ? 'selected' : ''); ?>>Ossetic</option>
				<option value="lb" <?php echo e($selected == 'lb' ? 'selected' : ''); ?>>Luxembourgish</option>
				<option value="ka" <?php echo e($selected == 'ka' ? 'selected' : ''); ?>>Georgian</option>
				<option value="mi" <?php echo e($selected == 'mi' ? 'selected' : ''); ?>>Maori</option>
				<option value="aa" <?php echo e($selected == 'aa' ? 'selected' : ''); ?>>Afar</option>
				<option value="ga" <?php echo e($selected == 'ga' ? 'selected' : ''); ?>>Irish</option>
				<option value="yi" <?php echo e($selected == 'yi' ? 'selected' : ''); ?>>Yiddish</option>
				<option value="km" <?php echo e($selected == 'km' ? 'selected' : ''); ?>>Khmer</option>
				<option value="mk" <?php echo e($selected == 'mk' ? 'selected' : ''); ?>>Macedonian</option>
				</select>
				</div>				
				<div class="selects-container selects-container-last">
					<p>Order By:</p>
					<select name="order_by">
						<?php 
							$selected = app('request')->input('order_by'); 
						 ?>						
						<option value="latest" <?php if($selected == 'latest'): ?> selected <?php endif; ?>>Latest</option>
						<option value="oldest" <?php if($selected == 'oldest'): ?> selected <?php endif; ?>>Oldest</option>
						<option value="year" <?php if($selected == 'year'): ?> selected <?php endif; ?>>Year</option>
						<option value="rating" <?php if($selected == 'rating'): ?> selected <?php endif; ?>>Rating</option>
						<option value="alphabetical" <?php if($selected == 'alphabetical'): ?> selected <?php endif; ?>>Alphabetical</option>
						<option value="downloads" <?php if($selected == 'downloads'): ?> selected <?php endif; ?>>Downloads</option>
					</select>
				</div>
			</div>
			<div id="main-search-btn">
				<input class="button-green-download2-big" type="submit" value="Search">
			</div>
		</form>
	</div>
</div>
<div class="browse-content">
	<div class="container">
		<h2><?php echo e(number_format($movies_count)); ?> <?php echo e(config('settings.site_title')); ?> Movies Found</h2>
		<div>
			<?php echo e($movies->appends(Input::except('page'))->links('vendor.pagination.front')); ?>

		</div>
		<section>
			<div class="row">
				<?php $__empty_1 = true; $__currentLoopData = $movies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>			
				<div class="browse-movie-wrap col-xs-10 col-sm-4 col-md-5 col-lg-4">
					<a href="<?php echo e($movie->url); ?>" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="<?php echo e($movie->thumbnail); ?>" alt="<?php echo e($movie->title_long); ?> YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating"><?php echo e($movie->rating); ?> / 10</h4>
                             <?php echo $movie->thumbnail_genres; ?>

							<span class="button-green-download2-big">View Details</span>
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="<?php echo e($movie->url); ?>" class="browse-movie-title"><?php echo e($movie->title); ?></a>
						<div class="browse-movie-year"><?php echo e($movie->year); ?></div>						
					</div>
				</div>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
				<h1 class="text-center">No results</h1>
				<br/><br/><br/><br/><br/><br/><br/><br/><br/><br/><br/>	
				<?php endif; ?>				
			</div><br/><br/><br/><br/>
		</section>
		<div>
			<?php echo e($movies->appends(Input::except('page'))->links('vendor.pagination.front')); ?>

		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>