

<?php $__env->startSection('meta'); ?>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<link rel="alternate" href="<?php echo e(url()->current()); ?>" hreflang="en" />
<meta name="revisit-after" content="1 days">
<meta name="robots" content="INDEX,FOLLOW">

<meta name="description" content="<?php echo e($movie->meta_description); ?>" />
<meta name="keywords" content="<?php echo e($movie->meta_keywords); ?>" />

<meta property="og:title" content="<?php echo e($movie->meta_title); ?>" />
<meta property="og:image" content="<?php echo e($movie->thumbnail); ?>" />
<meta property="og:description" content="<?php echo e($movie->meta_description); ?>" />
<meta property="og:url" content="<?php echo e(url()->current()); ?>" />

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:url" value="<?php echo e(url()->current()); ?>">
<meta name="twitter:title" content="<?php echo e($movie->meta_title); ?>">
<meta name="twitter:description" content="<?php echo e($movie->meta_description); ?>">
<meta name="twitter:image" content="<?php echo e($movie->thumbnail); ?>" />

<?php $__env->stopSection(); ?>

<?php $__env->startSection('after_styles'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.1.25/jquery.fancybox.min.css" />

<link rel="stylesheet" href="<?php echo e(url('css/pages/movie.min.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('after_scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.1.25/jquery.fancybox.min.js"></script>

<script type="text/javascript">
$("a.fancybox").fancybox({
   type: "iframe",
});	
</script>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('background_image'); ?>
	<?php if(!empty($movie->background_image)): ?>
<div id="background-image" style="background: url(<?php echo e($movie->background); ?>) no-repeat center center; background-size: cover; -webkit-background-size: cover;-moz-background-size: cover; -o-background-size: cover;"></div>
<div id="background-overlay"></div>
	<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container" id="movie-content" itemscope itemtype="http://schema.org/Movie">

	<div class="row">
		<div id="mobile-movie-info" class="visible-xs col-xs-20">
			<h1><?php echo e($movie->title); ?> YIFY</h1>
			<h2><?php echo e($movie->year); ?></h2>
			<h2><?php echo e(str_replace(',',' - ',$movie->genres)); ?></h2>
		</div>
		<div id="movie-poster" class="col-xs-10 col-sm-6 col-lg-5">


		   <a class="button-green-download2-big" href="https://get-link.xyz/go/?title=<?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>)" rel="nofollow sponsored" target="_blank" style="margin-bottom:8px;"><span class="icon-in"></span>Download in HD</a>
		    <a class="button-green-download2-big" href="https://get-link.xyz/get/?title=<?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>)" rel="nofollow sponsored" target="_blank" style="margin-bottom:8px;"><span class="icon-screen"></span> Stream in HD</a>
		    

			<?php if(Auth::check()): ?>
				<?php if(Auth::user()->hasRole('Administrator')): ?>
				<a class="button-green-download2-big" href="<?php echo e(route('admin.movie.tgx_torrents',[$movie->id])); ?>" style="margin-bottom:8px;">TGX</a>
				<a class="button-green-download2-big" href="<?php echo e(route('admin.movie.tgx_torrents',[$movie->id])); ?>" style="margin-bottom:8px;">1337x</a>
					<a class="button-green-download2-big" href="<?php echo e(url('admin/movie/edit/'.$movie->id)); ?>" style="margin-bottom:8px;">Edit Movie</a>
					<a class="button-green-download2-big" href="<?php echo e(url('admin/movie/'.$movie->id.'/torrent')); ?>" style="margin-bottom:8px;">Edit Torrents</a>
				<?php endif; ?>	
			<?php endif; ?>

		    
			<img class="img-responsive lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="<?php echo e($movie->thumbnail); ?>" alt="<?php echo e($movie->title); ?> YIFY Torrent" title="<?php echo e($movie->title); ?> On <?php echo e(strtoupper(request()->getHost())); ?>" />
			<a class="torrent-modal-download button-green-download2-big " href="javascript:void(0);"><span class="icon-in"></span>Download</a>
		</div>
		
		
		
		
		<div class="modal modal-download">
			<div class="modal-container" style="background-color:black;">
				<div class="modal-title"> Select movie quality </div>
				<span class="modal-close glyphicon glyphicon-remove"></span>
				<div class="modal-content">
				    <table class="table">
				        <thead>
                    <tr>
                        <td>Quality</td>
                        <td>Name</td>
                        <td>Size</td>
                        <td>Download</td>
                        <td>Magnet</td>
                    </tr>
                    </thead>
                    <tbody>
					<?php $__empty_1 = true; $__currentLoopData = $movie->torrents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $torrent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
					
                    <tr>
                        <td><?php echo e($torrent->quality); ?></td>
                        <td><?php echo e(strtoupper($torrent->type)); ?></td>
                        <td><?php echo e($torrent->size_f); ?></td>
                        <td><a download href="<?php echo e($torrent->download_url); ?>" rel="nofollow" title="<?php echo e($torrent->meta_title); ?>"><span class="icon-in" style="color:green"></span></a></td>
                        <td><a data-torrent-id="<?php echo e($torrent->id); ?>" href="magnet:?xt=urn:btih:<?php echo e($torrent->hash); ?>&dn=<?php echo e(urlencode($movie->title)); ?>&<?php echo e(config('settings.torrent_trackers')); ?>" class="magnet-download download-torrent magnet" title="<?php echo e($torrent->meta_magnet_title); ?>" rel="nofollow" style="margin-top: 0;"><span>Magnet</span></a></td>
                    </tr>					
					
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
					<tr>
					    <td colspan="5" class="text-center">Coming soon</td>
					</tr>
					<?php endif; ?>
					</tbody>
                    </table>


				</div>
			</div>
		</div>
		
		
		
		
		<div id="movie-info" class="col-xs-10 col-sm-14 col-md-7 col-lg-8 col-lg-offset-1 movie-info" data-movie-id="<?php echo e($movie->id); ?>">
			<div class="hidden-xs">
				<h1><?php echo e($movie->title); ?> YIFY</h1>
				<h2><?php echo e($movie->year); ?></h2>
				<h2><?php echo e(str_replace(',',' - ',$movie->genres)); ?></h2>
			</div>
			<p class="hidden-xs hidden-sm">
				<em class="pull-left">Available in: &nbsp;</em>
					<?php $__empty_1 = true; $__currentLoopData = $movie->torrents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $torrent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
					<a href="<?php echo e($torrent->download_url); ?>" rel="nofollow sponsored" title="<?php echo e($torrent->meta_title); ?>"><?php echo e($torrent->quality.'.'.strtoupper($torrent->type)); ?></a>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
					<a href="#" rel="nofollow" title="<?php echo e($movie->title); ?>">Coming Soon</a>
					<?php endif; ?>

			</p>			
			<p class="hidden-xs hidden-sm">
				<em class="pull-left">Watch Online: &nbsp;</em>
					<?php if(!empty($movie->video_link)): ?>
					<a href="<?php echo e(($movie->torrents->count() > 0) ? $movie->video_link : config('settings.watch_movie_alt')); ?>" <?php if($movie->torrents->count() > 0): ?> class="fancybox" <?php else: ?> target="_blank" <?php endif; ?> rel="nofollow" title="<?php echo e($movie->title); ?>"><span class="icon-screen" style="    margin-right: 5px;color: <?php echo e(config('settings.theme_pattern_color')); ?>;"></span> Watch Now </a>
					<?php endif; ?>
			</p>		
			<p class="hidden-xs hidden-sm">
			    
			<a href="<?php echo e('https://yify-subs.net/movie-imdb/'. $movie->imdb_code); ?>" target="_blank" title="Download subtitles for <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) 1080p"><span class="icon-in download_subtitles"></span> Download Subtitles</a>
		
			</p>
			<div class="bottom-info">
				<div class="rating-row">					
					<span title="Likes" class="icon icon-heart"></span>
					<span id="movie-likes"><?php echo e($movie->like_count); ?></span><span class="hidden-xs"> - Likes</span>
				</div>

				<div class="rating-row ">
					<a class="icon" rel="nofollow" target="_blank" href="https://www.rottentomatoes.com/m/<?php echo e(str_replace('-','_',str_slug($movie->title))); ?>" title="Rotten Tomatoes Critics - Rotten"> <img src="/img/rt-rotten.png" alt="Rotten Tomatoes Critics - Rotten - <?php echo e(strtoupper(request()->getHost())); ?>" /> </a>
					<span><?php echo e($movie->tomato_critics); ?>&#37;</span><span class="hidden-xs"> - Critics</span>
				</div>
				<div class="rating-row ">
					<a class="icon" rel="nofollow" target="_blank" href="https://www.rottentomatoes.com/m/<?php echo e(str_replace('-','_',str_slug($movie->title))); ?>" title="Rotten Tomatoes Audience - Spilled"> <img src="/img/rt-spilled.png" alt="Rotten Tomatoes Audience - Spilled - <?php echo e(strtoupper(request()->getHost())); ?>" /> </a>
					<span><?php echo e($movie->tomato_audience); ?>&#37;</span><span class="hidden-xs"> - Audience</span>
				</div>

<div class="rating-row" itemprop="aggregateRating" itemscope="" itemtype="http://schema.org/AggregateRating"> <a class="icon" href="https://www.imdb.com/title/<?php echo e($movie->imdb_code); ?>/" title="<?php echo e($movie->title); ?> IMDb Rating" target="_blank">
<img src="/img/logo-imdb.svg" alt="<?php echo e($movie->title); ?> Rating For <?php echo e($movie->title); ?> By <?php echo e(strtoupper(request()->getHost())); ?>"> </a>
<span itemprop="itemReviewed" style="display: none;"><?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>)</span>
<span itemprop="ratingValue"><?php echo e($movie->rating); ?></span>
<span itemprop="bestRating" style="display: none;">10</span> <span itemprop="ratingCount" style="display: none;"><?php echo e($movie->download_count); ?></span> 
<span class="hidden-xs icon-star"></span> 
</div>
				<?php if(!empty($movie->direct_link)): ?>
				<div class="rating-row hidden-sm hidden-xs">
				
				</div>
				<?php endif; ?>
				
					<div class="rating-row hidden-sm hidden-xs">
			
				</div>
				
				<div class="rating-row hidden-sm hidden-xs v211">
		            <?php if(config('settings.advertisement') == 1): ?>
		                <?php if(!empty(config('settings.advertisement_block_2'))): ?>                    
		                    <?php echo config('settings.advertisement_block_2'); ?>

		                <?php else: ?>
							<a href="<?php echo e(route('contact')); ?>" style="color: white; font-weight: bold">Advertise with Us</a>
		                <?php endif; ?>
		            <?php endif; ?>					
				</div>

			<p class="hidden-md hidden-lg">
				<?php $__empty_1 = true; $__currentLoopData = $movie->torrents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $torrent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
				<a href="<?php echo e($torrent->download_url); ?>" rel="nofollow sponsored" title="<?php echo e($torrent->meta_title); ?>"><span class="icon-in" style="color: <?php echo e(config('settings.theme_pattern_color')); ?>;"></span> <?php echo e($torrent->quality.'.'.strtoupper($torrent->type)); ?></a>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
				<a href="#" rel="nofollow" title="Coming soon <?php echo e($movie->title); ?>">Coming soon</a>
				<?php endif; ?>

			</p>


				<p class="hidden-md hidden-lg">
					<?php if(!empty($movie->video_link)): ?>
					<a href="<?php echo e($movie->video_link); ?>" class="fancybox" rel="nofollow" title="Watch <?php echo e($movie->title); ?> Online On <?php echo e(strtoupper(request()->getHost())); ?>"><span class="icon-screen" style="    margin-right: 5px;color: <?php echo e(config('settings.theme_pattern_color')); ?>;"></span> Watch Online </a>
					<?php endif; ?>

				</p>

			<p class="hidden-md hidden-lg">
			
			
				<a href="<?php echo e('https://yify-subs.net/movie-imdb/'. $movie->imdb_code); ?>" target="_blank" title="Download subtitles for <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) 1080p"><span class="icon-in download_subtitles"></span> Download Subtitles</a>
			
			</p>


			</div>
		</div>
		<div class="col-md-5 hidden-xs hidden-sm">
		     <a class="btn btn-danger btn-block mb-2 ml-4" href="/latest" target="_blank" style="width:100%;">LATEST MOVIES</a>
		     <a class="btn btn-danger btn-block mb-2 ml-4" href="/trending" target="_blank" style="width:100%;">TRENDING MOVIES</a>
		     <a class="btn btn-danger btn-block mb-2 ml-4" href="/upcoming" target="_blank" style="width:100%;">UPCOMING MOVIES</a>
		</div>
	<span></span>
		<div id="movie-related" class="col-md-6 hidden-xs hidden-sm">
			<p>Movies Like <?php echo e($movie->title); ?> YTS :</p>
			<?php $__empty_1 = true; $__currentLoopData = $similar_movies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $smovie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
			<a href="<?php echo e($smovie->url); ?>" title="<?php echo e($smovie->meta_title); ?>"><img class="img-fluid lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="<?php echo e($smovie->thumbnail); ?>" alt="<?php echo e($smovie->meta_title); ?>"></a>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
				<h3>No results</h3>
			<?php endif; ?>


		</div>
	</div>


	<div id="movie-sub-info" class="row">
		<div id="synopsis" class="col-sm-10 col-md-13 col-lg-12">
			<h3>Synopsis Of <?php echo e($movie->title); ?> Torrent On YIFY (<?php echo e(strtoupper(request()->getHost())); ?>) :</h3>
			<p class="hidden-sm hidden-md hidden-lg"> <?php echo e($movie->description_full); ?> </p>
			<p class="hidden-xs"> <?php echo e($movie->description_full); ?> </p>
			<p class="hidden-xs"> <?php echo e($movie->title); ?> YIFY MOVIE YTS: <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) Torrent, Download movie <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) over a torrent, <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) yify torrent, <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) magnet torrent, <?php echo e($movie->title); ?> (<?php echo e($movie->year); ?>) quality HD, 1080, 720, 3D, Bluray </p>
			
			<?php if(!empty($movie->writer)): ?>
			<p>
			    <br /> <em><?php echo e($movie->title); ?> Writers : <b> <?php echo e($movie->writer); ?> </b></em>
			</p>
			<?php endif; ?>
			
			<p>
			    <?php if(!empty($movie->production)): ?><br /> <em><?php echo e($movie->title); ?> Production : <b> <?php echo e($movie->production); ?> </b></em><?php endif; ?>
			    <?php if(!empty($movie->box_office)): ?><br /> <em><?php echo e($movie->title); ?> Box Office : <b> <?php echo e($movie->box_office); ?> </b></em><?php endif; ?>
			    <?php if(!empty($movie->awards)): ?><br /> <em><?php echo e($movie->title); ?> Awards : <b> <?php echo e($movie->awards); ?> </b></em><?php endif; ?>
			    <?php if(!empty($movie->country)): ?><br /> <em><?php echo e($movie->title); ?> Country : <b> <?php echo e($movie->country); ?> </b></em><?php endif; ?>
			</p>
			
			<p>
				<?php if(!empty($movie->user)): ?><br /> <em>Added By : <a href="<?php echo e($movie->user->url); ?>"><?php echo e($movie->user->name); ?></a> </em><?php endif; ?>
				<br /> <em>Download Count : <b> <?php echo e(number_format($movie->download_count)); ?> </b></em>
				<br /> <em>Source : <b>YIFY Torrent / YTS</b></em>
				<br /> <em>Updated & Posted On : <?php echo e($movie->created_at->format('F d, Y \a\t h:i A')); ?></em>
			</p>
		</div>
		<div id="crew" class="col-sm-10 col-md-7 col-lg-offset-1">
			<?php if(!empty($movie->director)): ?>
			<div class="directors">
				<h3>Director</h3>
				<div class="list-cast">
					<div class="tableCell">
					
						
					</div>
					<div class="list-cast-info tableCell">
						<a class="name-cast" href="<?php echo e(route('movie.index',['keyword'=>$movie->director])); ?>"><span itemprop="director" itemscope itemtype="http://schema.org/Person"><span itemprop="name"><?php echo e($movie->director); ?></span></span></a>
					</div>
				</div>
			</div>
			<?php endif; ?>
			
			
			<?php if(!empty($movie->cast)): ?>
			<div class="actors">
				<h3>Cast</h3>
				<?php  $casts = explode(',',$movie->cast);  ?>
				<?php $__empty_1 = true; $__currentLoopData = $casts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cast): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
					<?php  
					//	$artist = \Helpers::artist($cast);
						$cast_photo = url('/img/default_avatar.jpg');
					//	if(!empty($artist)){
					//		if(!empty($artist->photo) && file_exists(ltrim($artist->photo,'/'))) $cast_photo = $artist->photo;
					//	}
					 ?>
				<div class="list-cast">
					<div class="tableCell">
						<a class="avatar-thumb" href="http://www.imdb.com/find?q=<?php echo e($cast); ?>" target="_blank" title="IMDb Profile"> <img class="lazyload" src="<?php echo e(url('img/default_avatar.jpg')); ?>" data-src="<?php echo e($cast_photo); ?>" alt="<?php echo e($cast); ?> Picture"> </a>
					</div>
					<div class="list-cast-info tableCell">
						<a class="name-cast" href="<?php echo e(url('movies?keyword='.$cast)); ?>"><span itemprop="actor" itemscope itemtype="http://schema.org/Person"><span itemprop="name"><?php echo e($cast); ?></span></span></a>
					</div>
				</div>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
					<div>No results</div>
				<?php endif; ?>
			</div>
			<?php endif; ?>
		</div>
	</div>
	
	
		<div class="row trending_movies" style="margin-top:2rem;">
						
				<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/everything-everywhere-all-at-once-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/w3LxiVYdWWRvEVdn5RYq6jIqkb1.jpg" alt="EVERYTHING EVERYWHERE ALL AT ONCE YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.5 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/everything-everywhere-all-at-once-2022" target="_blank" class="browse-movie-title">EVERYTHING EVERYWHERE ALL AT ONCE YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>









<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/the-northman-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/8p9zXB7M78nZpm215zHfqpknMeM.jpg" alt="THE NORTHMAN YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/the-northman-2022" target="_blank" class="browse-movie-title">THE NORTHMAN YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>
				



<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/the-unbearable-weight-of-massive-talent-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/auIayZFR0JRYgiXRTQiaCR7bwjf.jpg" alt="The Unbearable Weight of Massive Talent YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.5 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/the-unbearable-weight-of-massive-talent-2022" target="_blank" class="browse-movie-title">The Unbearable Weight of Massive Talent YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>




<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/fantastic-beasts-the-secrets-of-dumbledore-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/f1VFSY863SDzN6EznMWejLSrlRG.jpg" alt="FANTASTIC BEASTS: THE SECRETS OF DUMBLEDORE YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.7 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/fantastic-beasts-the-secrets-of-dumbledore-2022" target="_blank" class="browse-movie-title">FANTASTIC BEASTS: THE SECRETS OF DUMBLEDORE YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>






<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/x-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/woTQx9Q4b8aO13jR9dsj8C9JESy.jpg" alt="X YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">9.5 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/x-2022" target="_blank" class="browse-movie-title">X YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>






<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/jujutsu-kaisen-0-2021" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/3pTwMUEavTzVOh6yLN0aEwR7uSy.jpg" alt="Jujutsu Kaisen 0 YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.3 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/jujutsu-kaisen-0-2021" target="_blank" class="browse-movie-title">Jujutsu Kaisen 0 YIFY</a>
						<div class="browse-movie-year">2021</div>						
					</div>
				</div>





<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/doctor-strange-in-the-multiverse-of-madness-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/wRnbWt44nKjsFPrqSmwYki5vZtF.jpg" alt="Doctor Strange in the Multiverse of Madness YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.1 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/doctor-strange-in-the-multiverse-of-madness-2022" target="_blank" class="browse-movie-title">Doctor Strange in the Multiverse of Madness YIFY</a>
						<div class="browse-movie-year">2021</div>						
					</div>
				</div>



<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/downton-abbey-a-new-era-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/yILwEHD3ZMPuOcYdqOP0aDAkyvx.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/yILwEHD3ZMPuOcYdqOP0aDAkyvx.jpg" alt="Downton Abbey: A New Era YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/downton-abbey-a-new-era-2022" target="_blank" class="browse-movie-title">Downton Abbey: A New Era YIFY</a>
						<div class="browse-movie-year">2021</div>						
					</div>
				</div>


<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/ambulance-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/zT5ynZ0UR6HFfWQSRf2uKtqCyWD.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/zT5ynZ0UR6HFfWQSRf2uKtqCyWD.jpg" alt="Ambulance YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/ambulance-2022" target="_blank" class="browse-movie-title">Ambulance YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>



<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/beast-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/fpqPTf4VzpSVkqdJNjhpmZzeufS.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/fpqPTf4VzpSVkqdJNjhpmZzeufS.jpg" alt="Beast YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/beast-2022" target="_blank" class="browse-movie-title">Beast YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>



<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/rrr-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/ncXklBeNi7X7OETqmDVEgaf8ItQ.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/ncXklBeNi7X7OETqmDVEgaf8ItQ.jpg" alt="RRR YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/rrr-2022" target="_blank" class="browse-movie-title">RRR YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>





<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/top-gun-maverick-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/62HCnUTziyWcpDaBO2i1DX17ljH.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/62HCnUTziyWcpDaBO2i1DX17ljH.jpg" alt="Top Gun: Maverick YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/top-gun-maverick-2022" target="_blank" class="browse-movie-title">Top Gun: Maverick YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>



<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/father-stu-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/pLAeWgqXbTeJ2gQtNvRmdIncYsk.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/pLAeWgqXbTeJ2gQtNvRmdIncYsk.jpg" alt="Father Stu YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/father-stu-2022" target="_blank" class="browse-movie-title">Father Stu YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>





<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/firestarter-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/2MTGip0nfahQ1jPQCZSfCsPBZes.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/2MTGip0nfahQ1jPQCZSfCsPBZes.jpg" alt="Firestarter YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/firestarter-2022" target="_blank" class="browse-movie-title">Firestarter YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>





<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/this-much-i-know-to-be-true-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/dNu0TT4eV4nk2dTcdixGJ3jNCzw.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/dNu0TT4eV4nk2dTcdixGJ3jNCzw.jpg" alt="This Much I Know to Be True YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/this-much-i-know-to-be-true-2022" target="_blank" class="browse-movie-title">This Much I Know to Be True YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>





<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/you-wont-be-alone-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/45W9ViL5ilurSLVzBEybYXHrxEJ.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/45W9ViL5ilurSLVzBEybYXHrxEJ.jpg" alt="You Won't Be Alone YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/you-wont-be-alone-2022" target="_blank" class="browse-movie-title">You Won't Be Alone YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>





<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/memory-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/zGPLpljwrlK2y7AWXVpGx0ceIyH.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/zGPLpljwrlK2y7AWXVpGx0ceIyH.jpg" alt="Memory YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/memory-2022" target="_blank" class="browse-movie-title">Memory YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>


<div class="browse-movie-wrap col-xs-6 col-sm-6 col-md-3">
					<a href="/movies/operation-mincemeat-2022" target="_blank" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="https://www.themoviedb.org/t/p/w220_and_h330_face/flLF4Oe4MTz6U6iqeLEULl6RCfu.jpg" data-src="https://www.themoviedb.org/t/p/w220_and_h330_face/flLF4Oe4MTz6U6iqeLEULl6RCfu.jpg" alt="Operation Mincemeat YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating">8.9 / 10</h4>
                             TRENDING
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="/movies/operation-mincemeat-2022" target="_blank" class="browse-movie-title">Operation Mincemeat YIFY</a>
						<div class="browse-movie-year">2022</div>						
					</div>
				</div>




														
			</div>	
	
	
	
	
	
	<div id="movie-tech-specs" class="row">
		<h3 class="hidden-xs hidden-sm col-md-5">Tech specs</h3>
		<?php $__currentLoopData = $movie->torrents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $torrent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		<span class="tech-quality col-md-2 <?php echo e($loop->iteration == 1 ? 'selected' : ''); ?>"> <?php echo e($torrent->quality.'.'.strtoupper(str_limit($torrent->type,3,''))); ?> </span>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		<?php $__currentLoopData = $movie->torrents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $torrent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		<div class="tech-spec-info col-xs-20 <?php echo e($loop->iteration > 1 ? 'hidden-tech-info' : ''); ?>">
			<div class="row">
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"><span title="File Size" class="icon-folder"></span> <?php echo e($torrent->size_f); ?> <div></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Resolution" class="icon-expand"></span> <?php echo e($torrent->resolution); ?> <div></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Language" class="icon-volume-medium"></span> <?php echo e($movie->language); ?> <div></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="MPA Rating" class="icon-eye"></span> <?php echo e((!empty($movie->mpa_rating)) ? $movie->mpa_rating : 'N/A'); ?> <div></div> </div>
			</div>
			<div class="row">
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Subtitles" class="glyphicon glyphicon-subtitles"></span> <a href="#subtitles">Subtitles</a> <div class="hidden-md hidden-lg"></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Frame Rate" class="icon-film"></span> <?php echo e($torrent->fps); ?> fps <div class="hidden-md hidden-lg"></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Runtime" class="icon-clock"></span> <?php echo e($movie->runtime_f); ?> <div class="visible-xs"></div> </div>
				<div class="tech-spec-element col-xs-20 col-sm-10 col-md-5"> <span title="Peers and Seeds" class="tech-peers-seeds">P/S</span> <?php echo e(number_format($torrent->peers)); ?> / <?php echo e(number_format($torrent->seeds)); ?> </div>
			</div>
		</div>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

	</div>



	<?php if(config('settings.disqus') == 1): ?>
	<div class="row blog" style="margin-top: 20px;">
		<div class="col-xs-20">
		<?php echo config('settings.disqus_code'); ?>

		</div>
	</div>		
	<?php endif; ?>

<?php if(config('settings.facebook_comments') == 1): ?>	
	<div class="row blog" style="margin-top: 20px;">
		<div class="col-xs-20">
			<div class="fb-comments" data-href="<?php echo e($movie->slug); ?>" data-width="100%" data-numposts="10" data-colorscheme="dark"></div>
		</div>
	</div>
<?php endif; ?>	

</div>	
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>