

<?php $__env->startSection('meta'); ?>
	<?php echo $__env->make('front.inc.default_meta', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('after_styles'); ?>
<style type="text/css">	
@media (min-width: 768px)
{
	.poster {
	    height: 255px;
	}
}
</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<div id="main-search" class="content-dark hidden-sm hidden-xs">
	<div class="container">
		<form method="get" action="<?php echo e(action('SeriesController@index')); ?>" accept-charset="UTF-8">
			<div id="main-search-fields">
				<p class="pull-left term">Search Term:</p>
				<input name="keyword" placeholder="Search for a series&hellip;" autocomplete="off" type="search" value="<?php echo e(app('request')->input('keyword')); ?>">
				<div class="selects-container">
					<p>Genre:</p>
					<select name="genre">
						<option value="">All</option>
						<?php 
							$selected = app('request')->input('genre'); 
						 ?>							
						<?php $__currentLoopData = $movie_genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($genre->name); ?>" <?php if($selected == $genre->name): ?> selected <?php endif; ?>><?php echo e($genre->name); ?></option>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</select>
				</div>
				<div class="selects-container">
					<p>Rating:</p>
					<select name="rating">
						<option value="0">All</option>
						<?php 
							$selected = app('request')->input('rating'); 
						 ?>
						<?php for($i = 9; $i > 0 ; $i--): ?>
						<option value="<?php echo e($i); ?>" <?php if($selected == $i): ?> selected <?php endif; ?>><?php echo e($i); ?>+</option>
						<?php endfor; ?>

					</select>
				</div>
				<div class="selects-container selects-container-last">
					<p>Order By:</p>
					<select name="order_by">
						<?php 
							$selected = app('request')->input('order_by'); 
						 ?>						
						<option value="latest" <?php if($selected == 'latest'): ?> selected <?php endif; ?>>Latest</option>
						<option value="oldest" <?php if($selected == 'oldest'): ?> selected <?php endif; ?>>Oldest</option>
						<option value="year" <?php if($selected == 'year'): ?> selected <?php endif; ?>>Year</option>
						<option value="rating" <?php if($selected == 'rating'): ?> selected <?php endif; ?>>Rating</option>
						<option value="alphabetical" <?php if($selected == 'alphabetical'): ?> selected <?php endif; ?>>Alphabetical</option>
						<option value="downloads" <?php if($selected == 'downloads'): ?> selected <?php endif; ?>>Downloads</option>
					</select>
				</div>
			</div>
			<div id="main-search-btn">
				<input class="button-green-download2-big" type="submit" value="Search">
			</div>
		</form>
	</div>
</div>
<div class="browse-content">
	<div class="container">
		<h2><?php echo e(number_format($series_count)); ?> <?php echo e(Config::Get('settings.site_title')); ?> Series Found</h2>
		<div>
			<?php echo e($series->appends(Input::except('page'))->links('vendor.pagination.front')); ?>

		</div>
		<section>
			<div class="row">
				<?php $__empty_1 = true; $__currentLoopData = $series; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>			
				<div class="browse-movie-wrap col-xs-10 col-sm-4 col-md-5 col-lg-4">
					<a href="<?php echo e($s->url); ?>" class="browse-movie-link">
						<figure>
							<img class="img-responsive poster lazyload" src="<?php echo e(url('img/default_thumbnail.svg')); ?>" data-src="<?php echo e($s->thumbnail); ?>" alt="<?php echo e($s->title_long); ?> YIFY" style="width: 170px;">
							<figcaption class="hidden-xs hidden-sm">
							<span class="icon-star"></span>
							<h4 class="rating"><?php echo e($s->rating); ?> / 10</h4>
                             <?php echo $s->thumbnail_genres; ?>

							<span class="button-green-download2-big">View Details</span>
							</figcaption>
						</figure>
					</a>
					<div class="browse-movie-bottom">
						<a href="<?php echo e($s->url); ?>" class="browse-movie-title"><?php echo e($s->title); ?></a>
						<div class="browse-movie-year"><?php echo e($s->year); ?></div>						
					</div>
				</div>				
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
				<h1 class="text-center">No results</h1>
				<br/><br/><br/><br/><br/><br/><br/><br/><br/><br/><br/>	
				<?php endif; ?>				
			</div><br/><br/><br/><br/>
		</section>
		<div>
			<?php echo e($series->appends(Input::except('page'))->links('vendor.pagination.front')); ?>

		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>