
<?php $__env->startSection('after_styles'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
	<div class="row" id="info-page">
		<div class="col-xs-20 col-md-10">
			<h2>User login</h2>
			<form id="login_form" method="post" action="<?php echo e(action('AjaxController@login')); ?>" accept-charset="UTF-8" autocorrect="off" autocapitalize="off" spellcheck="off">
				<?php echo e(csrf_field()); ?>

				<label for="username">Username or Email:</label> <input class="contact" name="username" type="text" id="username" value="">
				<label for="password">Password:</label> <input class="contact" name="password" type="password" value="" id="password">
				<?php echo Recaptcha::render(['theme'=>Config::Get('settings.recaptcha_colorscheme')]); ?>

				<span class="green-link">
					<a href="<?php echo e(route('register')); ?>">Create an Account</a>
					<a href="<?php echo e(url('forgot-password')); ?>">Forgot password?</a>
				</span>
				<div class="send-btn">
					<input class="button-green-download2-big" type="submit" value="Login">
				</div>
			</form>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after_scripts'); ?>
<script type="text/javascript">

$("#login_form").on('submit', function(event) {
	event.preventDefault();
	
	$.ajax({
		url: $(this).attr('action'),
		type: $(this).attr('method'),
		data: $(this).serialize(),
	})
	.done(function(d) {
	    if(d == '')
			window.location.reload();
		else{
		    d = JSON.parse(d);
    		if(d.status == "error"){
    			toastr.error(d.message);
    			grecaptcha.reset();
    		}
		}
		console.log(d)
	})
	.fail(function() {
		toastr.error('Some error occured');
	});
	return false;
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>