
<?php $__env->startSection('content'); ?>
<div class="gray-bg">
	<div class="container">
		<div id="info-page">
			<div class="row">
				<div class="col-xs-20 col-md-12">
					<h1><?php echo e($user->name); ?></h1>
				</div>
				<?php if(Auth::check()): ?>
				<?php if(Auth::user()->hasRole('Administrator')): ?>
				<div class="col-xs-20 col-md-4">
					<a class="edit-profile button-green-download2-big" href="<?php echo e(url('admin/dashboard')); ?>">Admin Panel</a>
				</div>
				<?php endif; ?>				
				<?php if($user->id == Auth::user()->id): ?>
				<div class="col-xs-20 col-md-4">
					<a class="edit-profile button-green-download2-big" href="<?php echo e(route('user.edit')); ?>">Edit</a>
				</div>
				<?php endif; ?>
				<?php endif; ?>
			</div>			
			<div class="line"></div>
			<div class="row">
				<div class="col-xs-20">
					<h2>Statistics</h2>
				</div>
			</div>
			<div class="row">
				<div class="col-xs-20 col-md-13 profile-stats">
					<div class="profile-container">
						<p><span>Joined:</span> <?php echo e($user->created_at->format('Y-m-d H:i')); ?></p>
						<p><span>Last Seen:</span> <?php echo e(date('Y-m-d H:i',strtotime($user->last_seen))); ?></p>
						<p><span>User Class:</span> <?php echo e($user->role()); ?></p>
						<p><span>Downloads:</span> <?php echo e($download_count); ?></p>
						<p><span>Uploads:</span> <?php echo e($upload_count); ?></p>
					</div>
				</div>
				<div class="hidden-xs hidden-sm col-md-6">
					<?php if(empty($user->avatar)): ?>
					<img class="profile-img img-responsive pull-right" src="/img/default_avatar.jpg" alt="<?php echo e($user->name); ?> Profile">
					<?php else: ?>
					<img class="profile-img img-responsive pull-right" src="<?php echo e($user->avatar); ?>" alt="<?php echo e($user->name); ?> Profile">
					<?php endif; ?>
				</div>
			</div>
<?php if(!empty($user->about_text)): ?>
	<?php if(Auth::check()): ?>
		<?php if(Auth::user()->id == $user->id): ?>
				<div class="row">
					<div class="col-xs-20">
						<div class="line"></div>
						<h2>About Me</h2>
						<p><?php echo e($user->about_text); ?></p>
					</div>
				</div>
		<?php else: ?>
				<div class="row">
					<div class="col-xs-20">
						<div class="line"></div>
						<h2>About <?php echo e($user->name); ?></h2>
						<p><?php echo e($user->about_text); ?></p>
					</div>
				</div>
		<?php endif; ?>
	<?php else: ?>
				<div class="row">
					<div class="col-xs-20">
						<div class="line"></div>
						<h2>About <?php echo e($user->name); ?></h2>
						<p><?php echo e($user->about_text); ?></p>
					</div>
				</div>
	<?php endif; ?>
<?php endif; ?>

			<div class="row">
				<div class="col-xs-20">
					<div class="line"></div>
					<h2>Recent Downloads</h2>
					<div class="row-fluid recent-downloads">
						<?php $__empty_1 = true; $__currentLoopData = $downloads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
						<div class="col-xs-10 col-sm-6 col-md-3">
							<a href="<?php echo e($movie->url); ?>" title="<?php echo e($movie->title_long); ?>"><img src="<?php echo e($movie->thumbnail); ?>" alt="<?php echo e($movie->title_long); ?> download"></a>
						</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
						<h3 style="text-align: center;">No results</h3>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>