<?php 
   if(Route::currentRouteName() == 'home'){
        $title = config('settings.site_title');
        if(isset($page_title)) $title .= ' - '.$page_title;
   } 
   else{
        $title = '';
        if(isset($page_title)) $title .= $page_title.' - ';
        $title .= config('settings.site_title');
   }
 ?>


<meta http-equiv="content-language" itemprop="inLanguage" content="en">
<meta charset="utf-8">
<meta property="og:locale" content="en_US"/>
<meta property="og:type" content="article"/>
<link rel="profile" href="https://gmpg.org/xfn/11"/>
<link rel="pingback" href=""/>
<link rel="canonical" href="<?php echo e(url()->current()); ?>"/>
<link rel="alternate" href="<?php echo e(url()->current()); ?>" hreflang="en" />
<meta name="revisit-after" content="1 days">
<meta name="robots" content="INDEX,FOLLOW">

<meta name="description" content="<?php echo e(config('settings.meta_description')); ?>" />
<meta name="keywords" content="<?php echo e(config('settings.meta_keywords')); ?>" />
<meta property="og:title" content="<?php echo e($title); ?>" />
<?php if(!empty(config('settings.site_logo'))): ?><meta property="og:image" content="<?php echo e(url(config('settings.site_logo'))); ?>" /><?php endif; ?>
<meta property="og:description" content="<?php echo e(config('settings.meta_description')); ?>" />
<meta property="og:url" content="<?php echo e(url()->current()); ?>" />


<meta property="og:title" content="<?php echo e($title); ?>" />
<?php if(!empty(config('settings.site_logo'))): ?><meta property="og:image" content="<?php echo e(url(config('settings.site_logo'))); ?>" /><?php endif; ?>
<meta property="og:description" content="<?php echo e(config('settings.meta_description')); ?>" />
<meta property="og:url" content="<?php echo e(url()->current()); ?>" />

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:url" value="<?php echo e(url()->current()); ?>">
<meta name="twitter:title" content="<?php echo e($title); ?>">
<meta name="twitter:description" content="<?php echo e(config('settings.meta_description')); ?>">
<?php if(!empty(config('settings.site_logo'))): ?><meta name="twitter:image" content="<?php echo e(url(config('settings.site_logo'))); ?>" /><?php endif; ?>