<?php

namespace Backpack\Base\app\Http\Controllers;

use App\Models\Genre;
use App\Models\Movie;
use App\Models\Page;
use App\User;


class AdminController extends Controller
{
    protected $data = []; // the information we send to the view

    /**
     * Create a new controller instance.
     */
    public function __construct()
    {
        $this->middleware('admin');
    }

    /**
     * Show the admin dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function dashboard()
    {
        $this->data['title'] = trans('backpack::base.dashboard'); // set the page title
        $this->data['users_count'] = \App\User::count();
        $this->data['movies_count'] = \App\Models\Movie::count();
        $this->data['genre_count'] = \App\Models\Genre::count();
        $this->data['active_users_count'] = \App\User::where('active',1)->count();
        $this->data['inactive_users_count'] = \App\User::where('active',0)->count();
        $this->data['banned_users_count'] = \App\User::where('active',2)->count();
        $this->data['pages_count'] = \Backpack\PageManager\app\Models\Page::count();

        $this->data['users'] = \App\User::orderBy('created_at','desc')->limit(8)->get();

        return view('backpack::dashboard', $this->data);
    }

    /**
     * Redirect to the dashboard.
     *
     * @return \Illuminate\Routing\Redirector|\Illuminate\Http\RedirectResponse
     */
    public function redirect()
    {
        // The '/admin' route is not to be used as a page, because it breaks the menu's active state.
        return redirect(config('backpack.base.route_prefix').'/dashboard');
    }
}
